"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.executeEditAction = executeEditAction;
exports.isEditActionCompatible = isEditActionCompatible;
var _react = _interopRequireDefault(require("react"));
require("./helpers.scss");
var _presentationContainers = require("@kbn/presentation-containers");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _public = require("@kbn/ui-actions-plugin/public");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function isEditActionCompatible(embeddable) {
  if (!(embeddable !== null && embeddable !== void 0 && embeddable.getInput)) return false;
  // display the action only if dashboard is on editable mode
  const inDashboardEditMode = embeddable.getInput().viewMode === 'edit';
  return Boolean((0, _utils.isLensEmbeddable)(embeddable) && embeddable.getIsEditable() && inDashboardEditMode);
}
async function executeEditAction({
  embeddable,
  startDependencies,
  isNewPanel,
  deletePanel,
  ...startServices
}) {
  const isCompatibleAction = await isEditActionCompatible(embeddable);
  if (!isCompatibleAction || !(0, _utils.isLensEmbeddable)(embeddable)) {
    throw new _public.IncompatibleActionError();
  }
  const rootEmbeddable = embeddable.getRoot();
  const overlayTracker = (0, _presentationContainers.tracksOverlays)(rootEmbeddable) ? rootEmbeddable : undefined;
  const ConfigPanel = await embeddable.openConfingPanel(startDependencies, isNewPanel, deletePanel);
  if (ConfigPanel) {
    const handle = startServices.overlays.openFlyout((0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.cloneElement(ConfigPanel, {
      closeFlyout: () => {
        if (overlayTracker) overlayTracker.clearOverlays();
        handle.close();
      }
    }), startServices), {
      className: 'lnsConfigPanel__overlay',
      size: 's',
      'data-test-subj': 'customizeLens',
      type: 'push',
      paddingSize: 'm',
      hideCloseButton: true,
      onClose: overlayRef => {
        if (overlayTracker) overlayTracker.clearOverlays();
        overlayRef.close();
      },
      outsideClickCloses: true
    });
    overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.openOverlay(handle, {
      focusedPanelId: embeddable.id
    });
  }
}