"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isLensApi = void 0;
var _presentationPublishing = require("@kbn/presentation-publishing");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isLensApi = api => {
  return Boolean(api && (0, _presentationPublishing.apiIsOfType)(api, 'lens') && typeof api.getSavedVis === 'function' && typeof api.canViewUnderlyingData === 'function' && typeof api.getViewUnderlyingDataArgs === 'function' && (0, _presentationPublishing.apiPublishesPanelTitle)(api) && (0, _presentationPublishing.apiPublishesUnifiedSearch)(api));
};
exports.isLensApi = isLensApi;