"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataLossWarning = exports.ChartOptionAppend = void 0;
require("./chart_switch.scss");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _shared_components = require("../../../../shared_components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDataLossWarning = dataLoss => {
  if (dataLoss === 'nothing') {
    return;
  }
  if (dataLoss === 'everything') {
    return _i18n.i18n.translate('xpack.lens.chartSwitch.dataLossEverything', {
      defaultMessage: 'Changing to this visualization clears the current configuration.'
    });
  }
  if (dataLoss === 'layers') {
    return _i18n.i18n.translate('xpack.lens.chartSwitch.dataLossLayersDescription', {
      defaultMessage: 'Changing to this visualization modifies currently selected layer`s configuration and removes all other layers.'
    });
  } else return _i18n.i18n.translate('xpack.lens.chartSwitch.dataLossColumns', {
    defaultMessage: `Changing to this visualization modifies the current configuration.`
  });
};
exports.getDataLossWarning = getDataLossWarning;
const DataLossWarning = ({
  content,
  id
}) => {
  if (!content) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    size: "s",
    "aria-label": content,
    type: "dot",
    color: "warning",
    content: content,
    iconProps: {
      className: 'lnsChartSwitch__chartIcon',
      'data-test-subj': `lnsChartSwitchPopoverAlert_${id}`
    }
  }));
};
const ChartOptionAppend = ({
  dataLoss,
  showExperimentalBadge,
  id
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "xs",
  responsive: false,
  alignItems: "center",
  className: "lnsChartSwitch__append"
}, showExperimentalBadge ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_shared_components.ExperimentalBadge, null)) : null, /*#__PURE__*/_react.default.createElement(DataLossWarning, {
  content: getDataLossWarning(dataLoss),
  id: id
}));
exports.ChartOptionAppend = ChartOptionAppend;