"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toExpression = toExpression;
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/data-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getExpressionForLayer(layer, layerId, refs) {
  var _layer$columns, _layer$timeField;
  if (!layer.columns || ((_layer$columns = layer.columns) === null || _layer$columns === void 0 ? void 0 : _layer$columns.length) === 0) {
    return null;
  }
  let idMapper = {};
  layer.columns.forEach(col => {
    if (idMapper[col.fieldName]) {
      idMapper[col.fieldName].push({
        id: col.columnId,
        label: col.fieldName
      });
    } else {
      idMapper = {
        ...idMapper,
        [col.fieldName]: [{
          id: col.columnId,
          label: col.fieldName
        }]
      };
    }
  });
  const timeFieldName = (_layer$timeField = layer.timeField) !== null && _layer$timeField !== void 0 ? _layer$timeField : undefined;
  if (!layer.table) {
    const textBasedQueryToAst = (0, _common.textBasedQueryStateToExpressionAst)({
      query: layer.query,
      timeFieldName,
      titleForInspector: _i18n.i18n.translate('xpack.lens.inspectorTextBasedRequestDataTitle', {
        defaultMessage: 'Visualization'
      }),
      descriptionForInspector: _i18n.i18n.translate('xpack.lens.inspectorTextBasedRequestDescription', {
        defaultMessage: 'This request queries Elasticsearch to fetch the data for the visualization.'
      })
    });
    textBasedQueryToAst.chain.push({
      type: 'function',
      function: 'lens_map_to_columns',
      arguments: {
        idMap: [JSON.stringify(idMapper)],
        isTextBased: [true]
      }
    });
    return textBasedQueryToAst;
  } else {
    return {
      type: 'expression',
      chain: [{
        type: 'function',
        function: 'var',
        arguments: {
          name: [layerId]
        }
      }, {
        type: 'function',
        function: 'lens_map_to_columns',
        arguments: {
          idMap: [JSON.stringify(idMapper)]
        }
      }]
    };
  }
}
function toExpression(state, layerId) {
  if (state.layers[layerId]) {
    return getExpressionForLayer(state.layers[layerId], layerId, state.indexPatternRefs);
  }
  return null;
}