"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextBasedDimensionEditor = TextBasedDimensionEditor;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _textBasedEditor = require("@kbn/text-based-editor");
var _field_select = require("./field_select");
var _utils = require("../utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TextBasedDimensionEditor(props) {
  var _props$state$layers$p;
  const [allColumns, setAllColumns] = (0, _react.useState)([]);
  const query = (_props$state$layers$p = props.state.layers[props.layerId]) === null || _props$state$layers$p === void 0 ? void 0 : _props$state$layers$p.query;
  (0, _react.useEffect)(() => {
    // in case the columns are not in the cache, I refetch them
    async function fetchColumns() {
      if (query) {
        const table = await (0, _textBasedEditor.fetchFieldsFromESQL)({
          esql: `${query.esql} | limit 0`
        }, props.expressions);
        if (table) {
          var _table$columns;
          const hasNumberTypeColumns = (_table$columns = table.columns) === null || _table$columns === void 0 ? void 0 : _table$columns.some(_utils.isNumeric);
          const columns = table.columns.map(col => {
            var _col$meta, _col$meta2;
            return {
              id: col.id,
              name: col.name,
              meta: (_col$meta = col === null || col === void 0 ? void 0 : col.meta) !== null && _col$meta !== void 0 ? _col$meta : {
                type: 'number'
              },
              compatible: props.isMetricDimension && hasNumberTypeColumns ? props.filterOperations({
                dataType: col === null || col === void 0 ? void 0 : (_col$meta2 = col.meta) === null || _col$meta2 === void 0 ? void 0 : _col$meta2.type,
                isBucketed: Boolean((0, _utils.isNotNumeric)(col)),
                scale: 'ordinal'
              }) : true
            };
          });
          setAllColumns(columns);
        }
      }
    }
    fetchColumns();
  }, [props, props.expressions, query]);
  const selectedField = (0, _react.useMemo)(() => {
    const layerColumns = props.state.layers[props.layerId].columns;
    return layerColumns === null || layerColumns === void 0 ? void 0 : layerColumns.find(column => column.columnId === props.columnId);
  }, [props.columnId, props.layerId, props.state.layers]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "text-based-languages-field-selection-row",
    label: _i18n.i18n.translate('xpack.lens.textBasedLanguages.chooseField', {
      defaultMessage: 'Field'
    }),
    fullWidth: true,
    className: "lnsIndexPatternDimensionEditor--padded"
  }, /*#__PURE__*/_react.default.createElement(_field_select.FieldSelect, {
    existingFields: allColumns !== null && allColumns !== void 0 ? allColumns : [],
    selectedField: selectedField,
    onChoose: choice => {
      var _allColumns$find;
      const meta = allColumns === null || allColumns === void 0 ? void 0 : (_allColumns$find = allColumns.find(f => f.name === choice.field)) === null || _allColumns$find === void 0 ? void 0 : _allColumns$find.meta;
      const newColumn = {
        columnId: props.columnId,
        fieldName: choice.field,
        meta
      };
      return props.setState(!selectedField ? {
        ...props.state,
        layers: {
          ...props.state.layers,
          [props.layerId]: {
            ...props.state.layers[props.layerId],
            columns: [...props.state.layers[props.layerId].columns, newColumn]
          }
        }
      } : {
        ...props.state,
        layers: {
          ...props.state.layers,
          [props.layerId]: {
            ...props.state.layers[props.layerId],
            columns: props.state.layers[props.layerId].columns.map(col => col.columnId !== props.columnId ? col : {
              ...col,
              fieldName: choice.field,
              meta
            })
          }
        }
      });
    }
  })), props.dataSectionExtra && /*#__PURE__*/_react.default.createElement("div", {
    style: {
      paddingLeft: _uiTheme.euiThemeVars.euiSize,
      paddingRight: _uiTheme.euiThemeVars.euiSize
    }
  }, props.dataSectionExtra));
}