"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IncludeExcludeRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTermsIncludeExcludeOptions = (include, exclude) => {
  const includeOptions = include === null || include === void 0 ? void 0 : include.map(term => ({
    label: String(term)
  }));
  const excludeOptions = exclude === null || exclude === void 0 ? void 0 : exclude.map(term => ({
    label: String(term)
  }));
  return {
    ...((includeOptions === null || includeOptions === void 0 ? void 0 : includeOptions.length) && {
      include: includeOptions
    }),
    ...((excludeOptions === null || excludeOptions === void 0 ? void 0 : excludeOptions.length) && {
      exclude: excludeOptions
    })
  };
};
const IncludeExcludeRow = ({
  include,
  exclude,
  tableRows,
  columnId,
  isNumberField,
  includeIsRegex,
  excludeIsRegex,
  updateParams
}) => {
  const [includeExcludeSelectedOptions, setIncludeExcludeSelectedOptions] = (0, _react.useState)(getTermsIncludeExcludeOptions(include, exclude));
  const [termsOptions, setTermsOptions] = (0, _react.useState)(undefined);
  const [isRegexUsed, setIsRegexUsed] = (0, _react.useState)({
    include: includeIsRegex,
    exclude: excludeIsRegex
  });
  const [regex, setRegex] = (0, _react.useState)({
    include: includeIsRegex ? include === null || include === void 0 ? void 0 : include[0] : '',
    exclude: excludeIsRegex ? exclude === null || exclude === void 0 ? void 0 : exclude[0] : ''
  });
  (0, _react.useEffect)(() => {
    if (isNumberField) {
      setIsRegexUsed({
        include: false,
        exclude: false
      });
    }
  }, [isNumberField]);
  (0, _react.useEffect)(() => {
    var _includeExcludeSelect;
    if (includeExcludeSelectedOptions !== null && includeExcludeSelectedOptions !== void 0 && (_includeExcludeSelect = includeExcludeSelectedOptions.include) !== null && _includeExcludeSelect !== void 0 && _includeExcludeSelect.length) return;
    const uniqueTerms = (0, _lodash.uniq)(tableRows === null || tableRows === void 0 ? void 0 : tableRows.map(row => row[columnId])).filter(row => row !== '__other__');
    const options = uniqueTerms === null || uniqueTerms === void 0 ? void 0 : uniqueTerms.map(row => {
      return {
        label: String(row)
      };
    });
    setTermsOptions(options);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [tableRows]);
  const onChangeIncludeExcludeOptions = (selectedOptions, operation) => {
    const options = {
      ...includeExcludeSelectedOptions,
      [operation]: selectedOptions
    };
    setIncludeExcludeSelectedOptions(options);
    const terms = selectedOptions.map(option => {
      if (!Number.isNaN(Number(option.label))) {
        return Number(option.label);
      }
      return option.label;
    });
    const param = `${operation}IsRegex`;
    updateParams(operation, terms, param, false);
  };
  const onCreateOption = (searchValue, flattenedOptions = [], operation) => {
    var _includeExcludeSelect2;
    const newOption = {
      label: searchValue
    };
    let includeExcludeOptions = [];
    const includeORExcludeSelectedOptions = (_includeExcludeSelect2 = includeExcludeSelectedOptions[operation]) !== null && _includeExcludeSelect2 !== void 0 ? _includeExcludeSelect2 : [];
    includeExcludeOptions = [...includeORExcludeSelectedOptions, newOption];
    const options = {
      ...includeExcludeSelectedOptions,
      [operation]: includeExcludeOptions
    };
    setIncludeExcludeSelectedOptions(options);
    const terms = includeExcludeOptions.map(option => {
      if (!Number.isNaN(Number(option.label))) {
        return Number(option.label);
      }
      return option.label;
    });
    const param = `${operation}IsRegex`;
    updateParams(operation, terms, param, false);
  };
  const onIncludeRegexChangeToDebounce = (0, _react.useCallback)(newIncludeValue => {
    setRegex({
      ...regex,
      include: newIncludeValue
    });
    updateParams('include', [newIncludeValue !== null && newIncludeValue !== void 0 ? newIncludeValue : ''], 'includeIsRegex', true);
  }, [regex, updateParams]);
  const onExcludeRegexChangeToDebounce = (0, _react.useCallback)(newExcludeValue => {
    setRegex({
      ...regex,
      exclude: newExcludeValue
    });
    updateParams('exclude', [newExcludeValue !== null && newExcludeValue !== void 0 ? newExcludeValue : ''], 'excludeIsRegex', true);
  }, [regex, updateParams]);
  const {
    inputValue: includeRegexValue,
    handleInputChange: onIncludeRegexValueChange
  } = (0, _visualizationUiComponents.useDebouncedValue)({
    onChange: onIncludeRegexChangeToDebounce,
    value: regex.include
  });
  const {
    inputValue: excludeRegexValue,
    handleInputChange: onExcludeRegexValueChange
  } = (0, _visualizationUiComponents.useDebouncedValue)({
    onChange: onExcludeRegexChangeToDebounce,
    value: regex.exclude
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.lens.indexPattern.terms.include', {
      defaultMessage: 'Include values'
    }),
    display: "rowCompressed",
    fullWidth: true,
    labelAppend: !isNumberField ? /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs"
      }, _i18n.i18n.translate('xpack.lens.indexPattern.terms.addRegex', {
        defaultMessage: 'Use regular expression'
      })),
      "data-test-subj": "lens-include-terms-regex-switch",
      compressed: true,
      checked: isRegexUsed.include,
      onChange: e => {
        const value = e.target.checked;
        setIsRegexUsed({
          ...isRegexUsed,
          include: value
        });
        setRegex({
          ...regex,
          include: ''
        });
        setIncludeExcludeSelectedOptions(getTermsIncludeExcludeOptions([], exclude));
        updateParams('include', [], 'includeIsRegex', value);
      }
    }) : null
  }, isRegexUsed.include ? /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: _i18n.i18n.translate('xpack.lens.indexPattern.terms.includeExcludePatternPlaceholder', {
      defaultMessage: 'Enter a regex to filter values'
    }),
    "data-test-subj": "lens-include-terms-regex-input",
    value: includeRegexValue,
    onChange: e => {
      onIncludeRegexValueChange(e.target.value);
    },
    "aria-label": _i18n.i18n.translate('xpack.lens.indexPattern.terms.includeExcludePatternPlaceholder', {
      defaultMessage: 'Enter a regex to filter values'
    })
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": _i18n.i18n.translate('xpack.lens.indexPattern.terms.include', {
      defaultMessage: 'Include values'
    }),
    placeholder: _i18n.i18n.translate('xpack.lens.indexPattern.terms.includeExcludePlaceholder', {
      defaultMessage: 'Select values or create a new one'
    }),
    options: termsOptions,
    selectedOptions: includeExcludeSelectedOptions.include,
    onChange: options => onChangeIncludeExcludeOptions(options, 'include'),
    onCreateOption: (searchValue, options) => onCreateOption(searchValue, options, 'include'),
    isClearable: true,
    "data-test-subj": "lens-include-terms-combobox",
    autoFocus: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.lens.indexPattern.terms.exclude', {
      defaultMessage: 'Exclude values'
    }),
    display: "rowCompressed",
    fullWidth: true,
    labelAppend: !isNumberField ? /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs"
      }, _i18n.i18n.translate('xpack.lens.indexPattern.terms.addRegex', {
        defaultMessage: 'Use regular expression'
      })),
      compressed: true,
      checked: isRegexUsed.exclude,
      onChange: e => {
        const value = e.target.checked;
        setIsRegexUsed({
          ...isRegexUsed,
          exclude: value
        });
        setRegex({
          ...regex,
          exclude: ''
        });
        setIncludeExcludeSelectedOptions(getTermsIncludeExcludeOptions(include, []));
        updateParams('exclude', [], 'excludeIsRegex', value);
      }
    }) : null
  }, isRegexUsed.exclude ? /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: _i18n.i18n.translate('xpack.lens.indexPattern.terms.includeExcludePatternPlaceholder', {
      defaultMessage: 'Enter a regex to filter values'
    }),
    value: excludeRegexValue,
    onChange: e => {
      onExcludeRegexValueChange(e.target.value);
    },
    "aria-label": _i18n.i18n.translate('xpack.lens.indexPattern.terms.includeExcludePatternPlaceholder', {
      defaultMessage: 'Enter a regex to filter values'
    })
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": _i18n.i18n.translate('xpack.lens.indexPattern.terms.exclude', {
      defaultMessage: 'Exclude values'
    }),
    placeholder: _i18n.i18n.translate('xpack.lens.indexPattern.terms.includeExcludePlaceholder', {
      defaultMessage: 'Select values or create a new one'
    }),
    options: termsOptions,
    selectedOptions: includeExcludeSelectedOptions.exclude,
    onChange: options => onChangeIncludeExcludeOptions(options, 'exclude'),
    onCreateOption: (searchValue, options) => onCreateOption(searchValue, options, 'exclude'),
    isClearable: true,
    "data-test-subj": "lens-exclude-terms-combobox",
    autoFocus: true
  })));
};
exports.IncludeExcludeRow = IncludeExcludeRow;