"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayerSettingsPanel = LayerSettingsPanel;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _randomSampling = require("@kbn/random-sampling");
var _utils = require("./utils");
var _ignore_global_filter = require("../../shared_components/ignore_global_filter");
var _lens_ui_telemetry = require("../../lens_ui_telemetry");
var _shared_components = require("../../shared_components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const samplingValues = [0.00001, 0.0001, 0.001, 0.01, 0.1, 1];
function LayerSettingsPanel({
  state,
  setState,
  layerId
}) {
  const isSamplingValueDisabled = !(0, _utils.isSamplingValueEnabled)(state.layers[layerId]);
  const currentValue = isSamplingValueDisabled ? samplingValues[samplingValues.length - 1] : state.layers[layerId].sampling;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    "data-test-subj": "lns-indexPattern-random-sampling-row",
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.lens.indexPattern.randomSampling.help",
      defaultMessage: "Lower sampling percentages increases the performance, but lowers the accuracy. Lower sampling percentages are best for large datasets. {link}",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: "https://www.elastic.co/guide/en/elasticsearch/reference/master/search-aggregations-random-sampler-aggregation.html",
          target: "_blank",
          external: true
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.lens.indexPattern.randomSampling.learnMore",
          defaultMessage: "View documentation"
        }))
      }
    }))),
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.lens.indexPattern.randomSampling.label', {
      defaultMessage: 'Sampling'
    }), ' ', /*#__PURE__*/_react.default.createElement(_shared_components.ExperimentalBadge, null))
  }, /*#__PURE__*/_react.default.createElement(_randomSampling.RandomSamplingSlider, {
    disabled: isSamplingValueDisabled,
    disabledReason: _i18n.i18n.translate('xpack.lens.indexPattern.randomSampling.disabledMessage', {
      defaultMessage: 'In order to select a reduced sampling percentage, you must remove any maximum or minimum functions applied on this layer.'
    }),
    values: samplingValues,
    currentValue: currentValue,
    "data-test-subj": "lns-indexPattern-random-sampling-slider",
    onChange: newSamplingValue => {
      if (newSamplingValue < 1) {
        (0, _lens_ui_telemetry.trackUiCounterEvents)('apply_random_sampling');
      }
      setState({
        ...state,
        layers: {
          ...state.layers,
          [layerId]: {
            ...state.layers[layerId],
            sampling: newSamplingValue
          }
        }
      });
    }
  })), /*#__PURE__*/_react.default.createElement(_ignore_global_filter.IgnoreGlobalFilterRowControl, {
    checked: !state.layers[layerId].ignoreGlobalFilters,
    onChange: () => {
      const newLayer = {
        ...state.layers[layerId],
        ignoreGlobalFilters: !state.layers[layerId].ignoreGlobalFilters
      };
      const newLayers = {
        ...state.layers
      };
      newLayers[layerId] = newLayer;
      (0, _lens_ui_telemetry.trackUiCounterEvents)(newLayer.ignoreGlobalFilters ? `ignore_global_filters` : `use_global_filters`);
      setState({
        ...state,
        layers: newLayers
      });
    }
  }));
}