"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createIndexPatternService = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/unified-search-plugin/public");
var _loader = require("./loader");
var _id_generator = require("../id_generator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This service is only available for the full editor version
 * and it encapsulate all the indexpattern methods and state
 * in a single object.
 * NOTE: this is not intended to be used with the Embeddable branch
 */

const createIndexPatternService = ({
  core,
  dataViews,
  updateIndexPatterns,
  replaceIndexPattern,
  uiActions,
  contextDataViewSpec
}) => {
  const showLoadingDataViewError = err => core.notifications.toasts.addError(err, {
    title: _i18n.i18n.translate('xpack.lens.indexPattern.dataViewLoadError', {
      defaultMessage: 'Error loading data view'
    })
  });
  return {
    updateDataViewsState: updateIndexPatterns,
    loadIndexPatterns: args => {
      return (0, _loader.loadIndexPatterns)({
        dataViews,
        ...args
      });
    },
    replaceDataViewId: async dataView => {
      const newDataView = await dataViews.create({
        ...dataView.toSpec(),
        id: (0, _id_generator.generateId)()
      });

      // Do not clear initial data view instance from cache
      // if adhoc data view id has been provided by the context.
      if (contextDataViewSpec && contextDataViewSpec.id !== dataView.id) {
        dataViews.clearInstanceCache(dataView.id);
      }
      const loadedPatterns = await (0, _loader.loadIndexPatterns)({
        dataViews,
        patterns: [newDataView.id],
        cache: {}
      });
      replaceIndexPattern(loadedPatterns[newDataView.id], dataView.id, {
        applyImmediately: true
      });
      const trigger = uiActions.getTrigger(_public.UPDATE_FILTER_REFERENCES_TRIGGER);
      const action = uiActions.getAction(_public.UPDATE_FILTER_REFERENCES_ACTION);
      action === null || action === void 0 ? void 0 : action.execute({
        trigger,
        fromDataView: dataView.id,
        toDataView: newDataView.id,
        usedDataViews: []
      });
    },
    ensureIndexPattern: args => (0, _loader.ensureIndexPattern)({
      onError: showLoadingDataViewError,
      dataViews,
      ...args
    }),
    getDefaultIndex: () => core.uiSettings.get('defaultIndex')
  };
};
exports.createIndexPatternService = createIndexPatternService;