"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LensEditConfigurationFlyout = LensEditConfigurationFlyout;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/text-based-languages/public");
var _expression_helpers = require("../../../editor_frame_service/editor_frame/expression_helpers");
var _utils = require("../../../datasources/text_based/utils");
var _state_management = require("../../../state_management");
var _utils2 = require("../../../utils");
var _layer_configuration_section = require("./layer_configuration_section");
var _flyout_wrapper = require("./flyout_wrapper");
var _helpers = require("./helpers");
var _suggestion_panel = require("../../../editor_frame_service/editor_frame/suggestion_panel");
var _get_application_user_messages = require("../../get_application_user_messages");
var _lens_ui_telemetry = require("../../../lens_ui_telemetry");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function LensEditConfigurationFlyout({
  attributes,
  coreStart,
  startDependencies,
  visualizationMap,
  datasourceMap,
  datasourceId,
  updatePanelState,
  updateSuggestion,
  setCurrentAttributes,
  closeFlyout,
  saveByRef,
  savedObjectId,
  updateByRefInput,
  output$,
  lensAdapters,
  navigateToLensEditor,
  displayFlyoutHeader,
  canEditTextBasedQuery,
  isNewPanel,
  deletePanel,
  hidesSuggestions,
  onApplyCb,
  onCancelCb,
  hideTimeFilterInfo
}) {
  var _visualization$active, _attributes$state$adH, _adHocDataViews$;
  const euiTheme = (0, _eui.useEuiTheme)();
  const previousAttributes = (0, _react.useRef)(attributes);
  const previousAdapters = (0, _react.useRef)(lensAdapters);
  const prevQuery = (0, _react.useRef)(attributes.state.query);
  const [query, setQuery] = (0, _react.useState)(attributes.state.query);
  const [errors, setErrors] = (0, _react.useState)();
  const [isInlineFlyoutVisible, setIsInlineFlyoutVisible] = (0, _react.useState)(true);
  const [isLayerAccordionOpen, setIsLayerAccordionOpen] = (0, _react.useState)(true);
  const [suggestsLimitedColumns, setSuggestsLimitedColumns] = (0, _react.useState)(false);
  const [isSuggestionsAccordionOpen, setIsSuggestionsAccordionOpen] = (0, _react.useState)(false);
  const [isVisualizationLoading, setIsVisualizationLoading] = (0, _react.useState)(false);
  const datasourceState = attributes.state.datasourceStates[datasourceId];
  const activeDatasource = datasourceMap[datasourceId];
  const {
    datasourceStates,
    visualization,
    isLoading,
    annotationGroups,
    searchSessionId
  } = (0, _state_management.useLensSelector)(state => state.lens);
  // use the latest activeId, but fallback to attributes
  const activeVisualization = visualizationMap[(_visualization$active = visualization.activeId) !== null && _visualization$active !== void 0 ? _visualization$active : attributes.visualizationType];
  const framePublicAPI = (0, _state_management.useLensSelector)(state => (0, _state_management.selectFramePublicAPI)(state, datasourceMap));
  framePublicAPI.absDateRange = (0, _utils2.getAbsoluteDateRange)(startDependencies.data.query.timefilter.timefilter);
  const layers = (0, _react.useMemo)(() => activeDatasource.getLayers(datasourceState), [activeDatasource, datasourceState]);
  const dispatch = (0, _state_management.useLensDispatch)();
  (0, _react.useEffect)(() => {
    const s = output$ === null || output$ === void 0 ? void 0 : output$.subscribe(() => {
      var _previousAdapters$cur, _previousAdapters$cur2;
      const activeData = {};
      const adaptersTables = (_previousAdapters$cur = previousAdapters.current) === null || _previousAdapters$cur === void 0 ? void 0 : (_previousAdapters$cur2 = _previousAdapters$cur.tables) === null || _previousAdapters$cur2 === void 0 ? void 0 : _previousAdapters$cur2.tables;
      const [table] = Object.values(adaptersTables || {});
      if (table) {
        // there are cases where a query can return a big amount of columns
        // at this case we don't suggest all columns in a table but the first
        // MAX_NUM_OF_COLUMNS
        setSuggestsLimitedColumns(table.columns.length >= _utils.MAX_NUM_OF_COLUMNS);
        layers.forEach(layer => {
          activeData[layer] = table;
        });
        dispatch((0, _state_management.onActiveDataChange)({
          activeData
        }));
      }
    });
    return () => s === null || s === void 0 ? void 0 : s.unsubscribe();
  }, [dispatch, output$, layers]);
  const attributesChanged = (0, _react.useMemo)(() => {
    var _visualizationMap$pre;
    const previousAttrs = previousAttributes.current;
    const datasourceStatesAreSame = datasourceStates[datasourceId].state && previousAttrs.state.datasourceStates[datasourceId] ? datasourceMap[datasourceId].isEqual(previousAttrs.state.datasourceStates[datasourceId], previousAttrs.references, datasourceStates[datasourceId].state, attributes.references) : false;
    const visualizationState = visualization.state;
    const customIsEqual = (_visualizationMap$pre = visualizationMap[previousAttrs.visualizationType]) === null || _visualizationMap$pre === void 0 ? void 0 : _visualizationMap$pre.isEqual;
    const visualizationStateIsEqual = customIsEqual ? (() => {
      try {
        return customIsEqual(previousAttrs.state.visualization, previousAttrs.references, visualizationState, attributes.references, annotationGroups);
      } catch (err) {
        return false;
      }
    })() : (0, _lodash.isEqual)(visualizationState, previousAttrs.state.visualization);
    return !visualizationStateIsEqual || !datasourceStatesAreSame;
  }, [attributes.references, datasourceId, datasourceMap, datasourceStates, visualizationMap, annotationGroups, visualization.state]);
  const onCancel = (0, _react.useCallback)(() => {
    const previousAttrs = previousAttributes.current;
    if (attributesChanged) {
      if (previousAttrs.visualizationType === visualization.activeId) {
        var _datasourceMap$dataso, _datasourceMap$dataso2;
        const currentDatasourceState = datasourceMap[datasourceId].injectReferencesToLayers ? (_datasourceMap$dataso = datasourceMap[datasourceId]) === null || _datasourceMap$dataso === void 0 ? void 0 : (_datasourceMap$dataso2 = _datasourceMap$dataso.injectReferencesToLayers) === null || _datasourceMap$dataso2 === void 0 ? void 0 : _datasourceMap$dataso2.call(_datasourceMap$dataso, previousAttrs.state.datasourceStates[datasourceId], previousAttrs.references) : previousAttrs.state.datasourceStates[datasourceId];
        updatePanelState === null || updatePanelState === void 0 ? void 0 : updatePanelState(currentDatasourceState, previousAttrs.state.visualization);
      } else {
        updateSuggestion === null || updateSuggestion === void 0 ? void 0 : updateSuggestion(previousAttrs);
      }
      if (savedObjectId) {
        updateByRefInput === null || updateByRefInput === void 0 ? void 0 : updateByRefInput(savedObjectId);
      }
    }
    // for a newly created chart, I want cancelling to also remove the panel
    if (isNewPanel && deletePanel) {
      deletePanel();
    }
    onCancelCb === null || onCancelCb === void 0 ? void 0 : onCancelCb();
    closeFlyout === null || closeFlyout === void 0 ? void 0 : closeFlyout();
  }, [attributesChanged, isNewPanel, deletePanel, closeFlyout, visualization.activeId, savedObjectId, datasourceMap, datasourceId, updatePanelState, updateSuggestion, updateByRefInput, onCancelCb]);
  const onApply = (0, _react.useCallback)(() => {
    var _activeVisualization$;
    const dsStates = Object.fromEntries(Object.entries(datasourceStates).map(([id, ds]) => {
      const dsState = ds.state;
      return [id, dsState];
    }));
    const references = (0, _utils2.extractReferencesFromState)({
      activeDatasources: Object.keys(datasourceStates).reduce((acc, id) => ({
        ...acc,
        [id]: datasourceMap[id]
      }), {}),
      datasourceStates,
      visualizationState: visualization.state,
      activeVisualization
    });
    const attrs = {
      ...attributes,
      state: {
        ...attributes.state,
        visualization: visualization.state,
        datasourceStates: dsStates
      },
      references,
      visualizationType: visualization.activeId
    };
    if (savedObjectId) {
      saveByRef === null || saveByRef === void 0 ? void 0 : saveByRef(attrs);
      updateByRefInput === null || updateByRefInput === void 0 ? void 0 : updateByRefInput(savedObjectId);
    }

    // check if visualization type changed, if it did, don't pass the previous visualization state
    const prevVisState = previousAttributes.current.visualizationType === visualization.activeId ? previousAttributes.current.state.visualization : undefined;
    const telemetryEvents = (_activeVisualization$ = activeVisualization.getTelemetryEventsOnSave) === null || _activeVisualization$ === void 0 ? void 0 : _activeVisualization$.call(activeVisualization, visualization.state, prevVisState);
    if (telemetryEvents && telemetryEvents.length) {
      (0, _lens_ui_telemetry.trackUiCounterEvents)(telemetryEvents);
    }
    onApplyCb === null || onApplyCb === void 0 ? void 0 : onApplyCb(attrs);
    closeFlyout === null || closeFlyout === void 0 ? void 0 : closeFlyout();
  }, [visualization.activeId, savedObjectId, closeFlyout, onApplyCb, datasourceStates, visualization.state, activeVisualization, attributes, datasourceMap, saveByRef, updateByRefInput]);
  const {
    getUserMessages
  } = (0, _get_application_user_messages.useApplicationUserMessages)({
    coreStart,
    framePublicAPI,
    activeDatasourceId: datasourceId,
    datasourceState: datasourceStates[datasourceId],
    datasource: datasourceMap[datasourceId],
    dispatch,
    visualization: activeVisualization,
    visualizationType: visualization.activeId,
    visualizationState: visualization
  });

  // needed for text based languages mode which works ONLY with adHoc dataviews
  const adHocDataViews = Object.values((_attributes$state$adH = attributes.state.adHocDataViews) !== null && _attributes$state$adH !== void 0 ? _attributes$state$adH : {});
  const runQuery = (0, _react.useCallback)(async (q, abortController) => {
    const attrs = await (0, _helpers.getSuggestions)(q, startDependencies, datasourceMap, visualizationMap, adHocDataViews, setErrors, abortController);
    if (attrs) {
      setCurrentAttributes === null || setCurrentAttributes === void 0 ? void 0 : setCurrentAttributes(attrs);
      setErrors([]);
      updateSuggestion === null || updateSuggestion === void 0 ? void 0 : updateSuggestion(attrs);
    }
    setIsVisualizationLoading(false);
  }, [startDependencies, datasourceMap, visualizationMap, adHocDataViews, setCurrentAttributes, updateSuggestion]);
  const isSaveable = (0, _react.useMemo)(() => {
    if (!attributesChanged) {
      return false;
    }
    if (!visualization.state || !visualization.activeId) {
      return false;
    }
    const visualizationErrors = getUserMessages(['visualization'], {
      severity: 'error'
    });
    // shouldn't build expression if there is any type of error other than an expression build error
    // (in which case we try again every time because the config might have changed)
    if (visualizationErrors.every(error => error.uniqueId === _utils2.EXPRESSION_BUILD_ERROR_ID)) {
      return Boolean((0, _expression_helpers.buildExpression)({
        visualization: activeVisualization,
        visualizationState: visualization.state,
        datasourceMap,
        datasourceStates,
        datasourceLayers: framePublicAPI.datasourceLayers,
        indexPatterns: framePublicAPI.dataViews.indexPatterns,
        dateRange: framePublicAPI.dateRange,
        nowInstant: startDependencies.data.nowProvider.get(),
        searchSessionId
      }));
    }
  }, [attributesChanged, activeVisualization, datasourceMap, datasourceStates, framePublicAPI.dataViews.indexPatterns, framePublicAPI.dateRange, framePublicAPI.datasourceLayers, searchSessionId, startDependencies.data.nowProvider, visualization.activeId, visualization.state, getUserMessages]);
  const textBasedMode = (0, _esQuery.isOfAggregateQueryType)(query) ? (0, _esQuery.getAggregateQueryMode)(query) : undefined;
  if (isLoading) return null;
  // Example is the Discover editing where we dont want to render the text based editor on the panel, neither the suggestions (for now)
  if (!canEditTextBasedQuery && hidesSuggestions) {
    return /*#__PURE__*/_react.default.createElement(_flyout_wrapper.FlyoutWrapper, {
      isInlineFlyoutVisible: isInlineFlyoutVisible,
      displayFlyoutHeader: displayFlyoutHeader,
      onCancel: onCancel,
      navigateToLensEditor: navigateToLensEditor,
      onApply: onApply,
      isScrollable: true,
      isNewPanel: isNewPanel,
      isSaveable: isSaveable
    }, /*#__PURE__*/_react.default.createElement(_layer_configuration_section.LayerConfiguration
    // TODO: remove this once we support switching to any chart in Discover
    , {
      onlyAllowSwitchToSubtypes: true,
      getUserMessages: getUserMessages,
      attributes: attributes,
      coreStart: coreStart,
      startDependencies: startDependencies,
      visualizationMap: visualizationMap,
      datasourceMap: datasourceMap,
      datasourceId: datasourceId,
      hasPadding: true,
      framePublicAPI: framePublicAPI,
      setIsInlineFlyoutVisible: setIsInlineFlyoutVisible
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_flyout_wrapper.FlyoutWrapper, {
    isInlineFlyoutVisible: isInlineFlyoutVisible,
    displayFlyoutHeader: displayFlyoutHeader,
    onCancel: onCancel,
    navigateToLensEditor: navigateToLensEditor,
    onApply: onApply,
    language: textBasedMode ? (0, _esQuery.getLanguageDisplayName)(textBasedMode) : '',
    isSaveable: isSaveable,
    isScrollable: false,
    isNewPanel: isNewPanel
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react2.css)`
            block-size: 100%;
            .euiFlexItem,
            .euiAccordion,
            .euiAccordion__triggerWrapper,
            .euiAccordion__childWrapper {
              min-block-size: 0;
            }
            .euiAccordion {
              display: flex;
              flex: 1;
              flex-direction: column;
            }
            .euiAccordion__childWrapper {
              ${(0, _eui.euiScrollBarStyles)(euiTheme)}
              overflow-y: auto !important;
              pointer-events: none;
              padding-left: ${_uiTheme.euiThemeVars.euiFormMaxWidth};
              margin-left: -${_uiTheme.euiThemeVars.euiFormMaxWidth};
              > * {
                pointer-events: auto;
              }

              .euiAccordion-isOpen & {
                block-size: auto !important;
                flex: 1;
              }
            }
            .lnsIndexPatternDimensionEditor-advancedOptions {
              .euiAccordion__childWrapper {
                flex: none;
                overflow: hidden !important;
              }
            }
          `,
    direction: "column",
    gutterSize: "none"
  }, (0, _esQuery.isOfAggregateQueryType)(query) && canEditTextBasedQuery && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "InlineEditingESQLEditor"
  }, /*#__PURE__*/_react.default.createElement(_public.TextBasedLangEditor, {
    query: query,
    onTextLangQueryChange: q => {
      setQuery(q);
      prevQuery.current = q;
    },
    expandCodeEditor: status => {},
    isCodeEditorExpanded: true,
    detectTimestamp: Boolean(adHocDataViews === null || adHocDataViews === void 0 ? void 0 : (_adHocDataViews$ = adHocDataViews[0]) === null || _adHocDataViews$ === void 0 ? void 0 : _adHocDataViews$.timeFieldName),
    hideTimeFilterInfo: hideTimeFilterInfo,
    errors: errors,
    warning: suggestsLimitedColumns ? _i18n.i18n.translate('xpack.lens.config.configFlyoutCallout', {
      defaultMessage: 'Displaying a limited portion of the available fields. Add more from the configuration panel.'
    }) : undefined,
    hideMinimizeButton: true,
    editorIsInline: true,
    hideRunQueryText: true,
    onTextLangQuerySubmit: async (q, a) => {
      if (q) {
        setIsVisualizationLoading(true);
        await runQuery(q, a);
      }
    },
    isDisabled: false,
    allowQueryCancellation: true,
    isLoading: isVisualizationLoading
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: isLayerAccordionOpen ? 1 : false,
    css: (0, _react2.css)`
              .euiAccordion__childWrapper {
                flex: ${isLayerAccordionOpen ? 1 : 'none'};
              }
              padding: 0 ${_uiTheme.euiThemeVars.euiSize};
            `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "layer-configuration",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      css: (0, _react2.css)`
                padding: 2px;
              }
            `
    }, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.lens.config.visualizationConfigurationLabel', {
      defaultMessage: 'Visualization configuration'
    }))),
    buttonProps: {
      paddingSize: 'm'
    },
    initialIsOpen: isLayerAccordionOpen,
    forceState: isLayerAccordionOpen ? 'open' : 'closed',
    onToggle: status => {
      if (status && isSuggestionsAccordionOpen) {
        setIsSuggestionsAccordionOpen(!status);
      }
      setIsLayerAccordionOpen(!isLayerAccordionOpen);
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_layer_configuration_section.LayerConfiguration, {
    attributes: attributes,
    getUserMessages: getUserMessages,
    coreStart: coreStart,
    startDependencies: startDependencies,
    visualizationMap: visualizationMap,
    datasourceMap: datasourceMap,
    datasourceId: datasourceId,
    framePublicAPI: framePublicAPI,
    setIsInlineFlyoutVisible: setIsInlineFlyoutVisible
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: isSuggestionsAccordionOpen ? 1 : false,
    "data-test-subj": "InlineEditingSuggestions",
    css: (0, _react2.css)`
                border-top: ${_uiTheme.euiThemeVars.euiBorderThin};
                border-bottom: ${_uiTheme.euiThemeVars.euiBorderThin};
                padding-left: ${_uiTheme.euiThemeVars.euiSize};
                padding-right: ${_uiTheme.euiThemeVars.euiSize};
                .euiAccordion__childWrapper {
                  flex: ${isSuggestionsAccordionOpen ? 1 : 'none'}
                }
              }
            `
  }, /*#__PURE__*/_react.default.createElement(_suggestion_panel.SuggestionPanel, {
    ExpressionRenderer: startDependencies.expressions.ReactExpressionRenderer,
    datasourceMap: datasourceMap,
    visualizationMap: visualizationMap,
    frame: framePublicAPI,
    core: coreStart,
    nowProvider: startDependencies.data.nowProvider,
    showOnlyIcons: true,
    wrapSuggestions: true,
    isAccordionOpen: isSuggestionsAccordionOpen,
    toggleAccordionCb: status => {
      if (!status && isLayerAccordionOpen) {
        setIsLayerAccordionOpen(status);
      }
      setIsSuggestionsAccordionOpen(!isSuggestionsAccordionOpen);
    }
  })))));
}