"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSuggestions = void 0;
var _esqlUtils = require("@kbn/esql-utils");
var _visualizationUtils = require("@kbn/visualization-utils");
var _lens_suggestions_api = require("../../../lens_suggestions_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSuggestions = async (query, deps, datasourceMap, visualizationMap, adHocDataViews, setErrors, abortController) => {
  try {
    var _suggestionsApi;
    const indexPattern = (0, _esqlUtils.getIndexPatternFromESQLQuery)(query.esql);
    const dataViewSpec = adHocDataViews.find(adHoc => {
      return adHoc.name === indexPattern;
    });
    const dataView = dataViewSpec ? await deps.dataViews.create(dataViewSpec) : await (0, _esqlUtils.getESQLAdHocDataview)(indexPattern, deps.dataViews);
    const columns = await (0, _esqlUtils.getESQLQueryColumns)({
      esqlQuery: 'esql' in query ? query.esql : '',
      search: deps.data.search.search,
      signal: abortController === null || abortController === void 0 ? void 0 : abortController.signal
    });
    const context = {
      dataViewSpec: dataView === null || dataView === void 0 ? void 0 : dataView.toSpec(false),
      fieldName: '',
      textBasedColumns: columns,
      query
    };
    const allSuggestions = (_suggestionsApi = (0, _lens_suggestions_api.suggestionsApi)({
      context,
      dataView,
      datasourceMap,
      visualizationMap
    })) !== null && _suggestionsApi !== void 0 ? _suggestionsApi : [];

    // Lens might not return suggestions for some cases, i.e. in case of errors
    if (!allSuggestions.length) return undefined;
    const firstSuggestion = allSuggestions[0];
    const attrs = (0, _visualizationUtils.getLensAttributesFromSuggestion)({
      filters: [],
      query,
      suggestion: firstSuggestion,
      dataView
    });
    return attrs;
  } catch (e) {
    setErrors([e]);
  }
  return undefined;
};
exports.getSuggestions = getSuggestions;