"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerCountRoute = exports.doCount = void 0;
var _configSchema = require("@kbn/config-schema");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerCountRoute = (router, logger) => {
  router.versioned.get({
    access: 'internal',
    path: _constants.COUNT_ROUTE
  }).addVersion({
    version: '1',
    validate: {
      request: {
        query: _configSchema.schema.object({
          index: _configSchema.schema.string(),
          query: _configSchema.schema.string(),
          field: _configSchema.schema.oneOf([_configSchema.schema.literal(_constants.ORCHESTRATOR_CLUSTER_ID), _configSchema.schema.literal(_constants.ORCHESTRATOR_RESOURCE_ID), _configSchema.schema.literal(_constants.ORCHESTRATOR_NAMESPACE), _configSchema.schema.literal(_constants.ORCHESTRATOR_CLUSTER_NAME), _configSchema.schema.literal(_constants.CLOUD_INSTANCE_NAME), _configSchema.schema.literal(_constants.CONTAINER_IMAGE_NAME), _configSchema.schema.literal(_constants.CONTAINER_IMAGE_NAME), _configSchema.schema.literal(_constants.ENTRY_LEADER_ENTITY_ID)])
        })
      }
    }
  }, async (context, request, response) => {
    const client = (await context.core).elasticsearch.client.asCurrentUser;
    const {
      query,
      field,
      index
    } = request.query;
    try {
      const body = await doCount(client, index, query, field);
      return response.ok({
        body
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      logger.error(`Failed to fetch k8s counts: ${err}`);
      return response.customError({
        body: {
          message: error.message
        },
        statusCode: error.statusCode
      });
    }
  });
};
exports.registerCountRoute = registerCountRoute;
const doCount = async (client, index, query, field) => {
  var _search$aggregations;
  const queryDSL = JSON.parse(query);
  const search = await client.search({
    index: [index],
    body: {
      query: queryDSL,
      size: 0,
      aggs: {
        custom_count: {
          cardinality: {
            field
          }
        }
      }
    }
  });
  const agg = (_search$aggregations = search.aggregations) === null || _search$aggregations === void 0 ? void 0 : _search$aggregations.custom_count;
  return (agg === null || agg === void 0 ? void 0 : agg.value) || 0;
};
exports.doCount = doCount;