"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Storage = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class Storage {
  constructor(store) {
    (0, _defineProperty2.default)(this, "store", void 0);
    (0, _defineProperty2.default)(this, "get", key => {
      if (!this.store) {
        return null;
      }
      const storageItem = this.store.getItem(key);
      if (storageItem === null) {
        return null;
      }
      try {
        return JSON.parse(storageItem);
      } catch (error) {
        return null;
      }
    });
    (0, _defineProperty2.default)(this, "set", (key, value, includeUndefined = false) => {
      const replacer = includeUndefined ? (_, currentValue) => typeof currentValue === 'undefined' ? null : currentValue : undefined;
      try {
        return this.store.setItem(key, JSON.stringify(value, replacer));
      } catch (e) {
        return false;
      }
    });
    (0, _defineProperty2.default)(this, "remove", key => {
      return this.store.removeItem(key);
    });
    (0, _defineProperty2.default)(this, "clear", () => {
      return this.store.clear();
    });
    this.store = store;
  }
}
exports.Storage = Storage;