"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseUrlHash = exports.parseUrl = void 0;
var _url = require("url");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const parseUrl = url => (0, _url.parse)(url, true);
exports.parseUrl = parseUrl;
const parseUrlHash = url => {
  const hash = parseUrl(url).hash;
  return hash ? parseUrl(hash.slice(1)) : null;
};
exports.parseUrlHash = parseUrlHash;