"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UrlTemplateEditor = void 0;
var React = _interopRequireWildcard(require("react"));
var _monaco = require("@kbn/monaco");
var _codeEditor = require("@kbn/code-editor");
require("./styles.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const UrlTemplateEditor = ({
  height = 105,
  fitToContent,
  value,
  variables,
  onChange,
  placeholder,
  onEditor,
  Editor = _codeEditor.CodeEditor
}) => {
  const refEditor = React.useRef(null);
  const handleEditor = React.useCallback(editor => {
    refEditor.current = editor;
    if (onEditor) {
      onEditor(editor);
    }
  }, []);
  const handleKeyDown = React.useCallback(event => {
    const editor = refEditor.current;
    if (!editor) return;
    if (event.key === 'Escape') {
      if (editor.hasWidgetFocus()) {
        // Don't propagate Escape click if Monaco editor is focused, this allows
        // user to close the autocomplete widget with Escape button without
        // closing the EUI flyout.
        event.stopPropagation();
        editor.trigger('editor', 'hideSuggestWidget', []);
      }
    }
  }, []);
  React.useEffect(() => {
    if (!variables) {
      return;
    }
    const {
      dispose
    } = _monaco.monaco.languages.registerCompletionItemProvider(_codeEditor.HandlebarsLang, {
      triggerCharacters: ['{', '/', '?', '&', '='],
      provideCompletionItems(model, position, context, token) {
        const {
          lineNumber
        } = position;
        const line = model.getLineContent(lineNumber);
        const wordUntil = model.getWordUntilPosition(position);
        const word = model.getWordAtPosition(position) || wordUntil;
        const {
          startColumn,
          endColumn
        } = word;
        const range = {
          startLineNumber: lineNumber,
          endLineNumber: lineNumber,
          startColumn,
          endColumn
        };
        const leadingMustacheCount = 0 + (line[range.startColumn - 2] === '{' ? 1 : 0) + (line[range.startColumn - 3] === '{' ? 1 : 0);
        const trailingMustacheCount = 0 + (line[range.endColumn - 1] === '}' ? 1 : 0) + (line[range.endColumn + 0] === '}' ? 1 : 0);
        return {
          suggestions: variables.map(({
            label,
            title = '',
            documentation = '',
            kind = _monaco.monaco.languages.CompletionItemKind.Variable,
            sortText
          }) => ({
            kind,
            label,
            insertText: (leadingMustacheCount === 2 ? '' : leadingMustacheCount === 1 ? '{' : '{{') + label + (trailingMustacheCount === 2 ? '' : trailingMustacheCount === 1 ? '}' : '}}'),
            detail: title,
            documentation,
            range,
            sortText
          }))
        };
      }
    });
    return () => {
      dispose();
    };
  }, [variables]);
  return /*#__PURE__*/React.createElement("div", {
    className: 'urlTemplateEditor__container',
    onKeyDown: handleKeyDown
  }, /*#__PURE__*/React.createElement(Editor, {
    languageId: _codeEditor.HandlebarsLang,
    height: height,
    fitToContent: fitToContent,
    value: value,
    onChange: onChange,
    editorDidMount: handleEditor,
    placeholder: placeholder,
    options: {
      fontSize: 14,
      renderLineHighlight: 'none',
      lineNumbers: 'off',
      glyphMargin: false,
      folding: false,
      lineDecorationsWidth: 2,
      quickSuggestions: {
        comments: false,
        strings: false,
        other: false
      },
      suggestOnTriggerCharacters: true,
      minimap: {
        enabled: false
      },
      guides: {
        highlightActiveIndentation: false
      },
      wordWrap: 'on',
      wrappingIndent: 'none',
      automaticLayout: true,
      scrollBeyondLastLine: false,
      overviewRulerLanes: 0,
      padding: {
        top: 8,
        bottom: 8
      }
    }
  }));
};
exports.UrlTemplateEditor = UrlTemplateEditor;