"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoDataPageBody = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _solution_nav = require("../../solution_nav");
var _action_cards = require("../action_cards");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const NoDataPageBody = props => {
  const {
    pageTitle,
    docsLink,
    solution,
    actionCards,
    logo
  } = props;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement(_solution_nav.KibanaPageTemplateSolutionNavAvatar, {
    name: solution,
    iconType: logo || `logo${solution}`,
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement("h1", null, pageTitle), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "kibana-react.noDataPage.intro",
    defaultMessage: "Add your data to get started, or {link} about {solution}.",
    values: {
      solution,
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docsLink
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "kibana-react.noDataPage.intro.link",
        defaultMessage: "learn more"
      }))
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_action_cards.ActionCards, {
    actionCards: actionCards
  }));
};
exports.NoDataPageBody = NoDataPageBody;