"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createNotifications = void 0;
var React = _interopRequireWildcard(require("react"));
var _util = require("../util");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createNotifications = services => {
  const show = ({
    title,
    body,
    color,
    iconType,
    toastLifeTimeMs,
    onClose
  }) => {
    var _services$theme, _services$theme2;
    if (!services.notifications) {
      throw new TypeError('Could not show notification as notifications service is not available.');
    }
    services.notifications.toasts.add({
      title: (0, _util.toMountPoint)(title, {
        theme$: (_services$theme = services.theme) === null || _services$theme === void 0 ? void 0 : _services$theme.theme$
      }),
      text: (0, _util.toMountPoint)( /*#__PURE__*/React.createElement(React.Fragment, null, body || null), {
        theme$: (_services$theme2 = services.theme) === null || _services$theme2 === void 0 ? void 0 : _services$theme2.theme$
      }),
      color,
      iconType,
      toastLifeTimeMs,
      onClose
    });
  };
  const success = input => show({
    color: 'success',
    iconType: 'check',
    ...input
  });
  const warning = input => show({
    color: 'warning',
    iconType: 'help',
    ...input
  });
  const danger = input => show({
    color: 'danger',
    iconType: 'error',
    ...input
  });
  const notifications = {
    toasts: {
      show,
      success,
      warning,
      danger
    }
  };
  return notifications;
};
exports.createNotifications = createNotifications;