"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaOverviewPlugin = void 0;
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _public = require("@kbn/core/public");
var _common = require("../common");
var _ui_metric = require("./lib/ui_metric");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
class KibanaOverviewPlugin {
  setup(core, {
    home,
    usageCollection
  }) {
    if (usageCollection) {
      (0, _ui_metric.init)(usageCollection.reportUiCounter);
    }
    const appUpdater$ = (0, _rxjs.from)(core.getStartServices()).pipe((0, _rxjs.switchMap)(([coreDeps]) => coreDeps.chrome.navLinks.getNavLinks$()), (0, _rxjs.map)(navLinks => {
      const hasKibanaApp = Boolean(navLinks.find(({
        id,
        category,
        visibleIn
      }) => visibleIn.length > 0 && (category === null || category === void 0 ? void 0 : category.id) === 'kibana' && id !== _common.PLUGIN_ID));
      return hasKibanaApp;
    }), (0, _rxjs.distinct)(), (0, _rxjs.map)(hasKibanaApp => {
      return () => {
        return {
          status: hasKibanaApp ? _public.AppStatus.accessible : _public.AppStatus.inaccessible
        };
      };
    }));

    // Register an application into the side navigation menu
    core.application.register({
      category: _public.DEFAULT_APP_CATEGORIES.kibana,
      id: _common.PLUGIN_ID,
      title: _common.PLUGIN_NAME,
      euiIconType: _common.PLUGIN_ICON,
      order: 1,
      updater$: appUpdater$,
      appRoute: _common.PLUGIN_PATH,
      visibleIn: ['globalSearch', 'home', 'sideNav'],
      async mount(params) {
        // Load application bundle
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
        // Get start services as specified in kibana.json
        const [coreStart, depsStart] = await core.getStartServices();

        // Render the application
        return renderApp(coreStart, depsStart, params);
      }
    });
    if (home) {
      home.featureCatalogue.registerSolution({
        id: 'kibana',
        title: _i18n.i18n.translate('kibanaOverview.kibana.solution.title', {
          defaultMessage: 'Analytics'
        }),
        description: _i18n.i18n.translate('kibanaOverview.kibana.solution.description', {
          defaultMessage: 'Explore, visualize, and analyze your data using a powerful suite of analytical tools and applications.'
        }),
        icon: 'logoKibana',
        path: _common.PLUGIN_PATH,
        order: 400
      });
    }

    // Return methods that should be available to other plugins
    return {};
  }
  start(core) {
    return {};
  }
  stop() {}
}
exports.KibanaOverviewPlugin = KibanaOverviewPlugin;