"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.minimalTimeKeyRT = exports.DateFromStringOrNumber = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _moment = _interopRequireDefault(require("moment"));
var _pipeable = require("fp-ts/lib/pipeable");
var _Either = require("fp-ts/lib/Either");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const NANO_DATE_PATTERN = /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}.\d{3,9}Z$/;
const DateFromStringOrNumber = exports.DateFromStringOrNumber = new rt.Type('DateFromStringOrNumber', input => typeof input === 'string', (input, context) => {
  if (typeof input === 'string') {
    return NANO_DATE_PATTERN.test(input) ? rt.success(input) : rt.failure(input, context);
  }
  return (0, _pipeable.pipe)(rt.number.validate(input, context), (0, _Either.chain)(timestamp => {
    const momentValue = (0, _moment.default)(timestamp);
    return momentValue.isValid() ? rt.success(momentValue.toISOString()) : rt.failure(timestamp, context);
  }));
}, String);
const minimalTimeKeyRT = exports.minimalTimeKeyRT = rt.type({
  time: DateFromStringOrNumber,
  tiebreaker: rt.number
});
const timeKeyRT = rt.intersection([minimalTimeKeyRT, rt.partial({
  gid: rt.string,
  fromAutoReload: rt.boolean
})]);