"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.strictKeysRt = strictKeysRt;
var t = _interopRequireWildcard(require("io-ts"));
var _Either = require("fp-ts/lib/Either");
var _lodash = require("lodash");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/*
  Type that tracks validated keys, and fails when the input value
  has keys that have not been validated.
*/

const tags = ['DictionaryType', 'IntersectionType', 'MergeType', 'InterfaceType', 'PartialType', 'ExactType', 'UnionType', 'ArrayType', 'AnyType'];
function isParsableType(type) {
  return tags.includes(type._tag);
}
function getHandlingTypes(type, key, value) {
  if (!isParsableType(type)) {
    return [];
  }
  switch (type._tag) {
    case 'AnyType':
      return [type];
    case 'ArrayType':
      return [type.type];
    case 'DictionaryType':
      return [type.codomain];
    case 'IntersectionType':
      return type.types.map(i => getHandlingTypes(i, key, value)).flat();
    case 'MergeType':
      return type.types.map(i => getHandlingTypes(i, key, value)).flat();
    case 'InterfaceType':
    case 'PartialType':
      return [type.props[key]];
    case 'ExactType':
      return getHandlingTypes(type.type, key, value);
    case 'UnionType':
      const matched = type.types.find(m => (0, _Either.isRight)(m.decode(value)));
      return matched ? getHandlingTypes(matched, key, value) : [];
  }
}
function getHandledKeys(type, object, prefix = '') {
  const keys = {
    handled: new Set(),
    all: new Set()
  };
  (0, _lodash.forEach)(object, (value, key) => {
    const ownPrefix = prefix ? `${prefix}.${key}` : key;
    keys.all.add(ownPrefix);
    const handlingTypes = getHandlingTypes(type, key, object).filter(Boolean);
    if (handlingTypes.length) {
      keys.handled.add(ownPrefix);
    }
    if ((0, _lodash.isPlainObject)(value)) {
      handlingTypes.forEach(i => {
        const nextKeys = getHandledKeys(i, value, ownPrefix);
        nextKeys.all.forEach(k => keys.all.add(k));
        nextKeys.handled.forEach(k => keys.handled.add(k));
      });
    }
  });
  return keys;
}
function strictKeysRt(type) {
  return new t.Type(type.name, type.is, (input, context) => {
    return _Either.either.chain(type.validate(input, context), i => {
      const keys = getHandledKeys(type, input);
      const excessKeys = (0, _lodash.difference)([...keys.all], [...keys.handled]);
      if (excessKeys.length) {
        return t.failure(i, context, `Excess keys are not allowed:\n${excessKeys.join('\n')}`);
      }
      return t.success(i);
    });
  }, type.encode);
}