"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEsFilterFromGlobalParameters = getEsFilterFromGlobalParameters;
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getEsFilterFromGlobalParameters({
  query,
  filters,
  timeRange
}) {
  const esFilter = (0, _esQuery.buildEsQuery)(undefined, query !== null && query !== void 0 ? query : [], filters !== null && filters !== void 0 ? filters : []);
  if (timeRange) {
    esFilter.bool.filter.push({
      range: {
        '@timestamp': {
          gte: timeRange.from,
          lte: timeRange.to
        }
      }
    });
  }
  return esFilter;
}