"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Providers = exports.InteractiveSetupPlugin = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _app = require("./app");
var _use_kibana = require("./use_kibana");
var _use_verification = require("./use_verification");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class InteractiveSetupPlugin {
  setup(core) {
    core.application.register({
      id: 'interactiveSetup',
      title: 'Configure Elastic to get started',
      appRoute: '/',
      chromeless: true,
      mount: async ({
        element
      }) => {
        const url = new URL(window.location.href);
        const defaultCode = url.searchParams.get('code') || undefined;
        const onSuccess = () => {
          url.searchParams.delete('code');
          window.location.replace(url.href);
        };
        const [services] = await core.getStartServices();
        _reactDom.default.render( /*#__PURE__*/_react.default.createElement(Providers, {
          defaultCode: defaultCode,
          services: services
        }, /*#__PURE__*/_react.default.createElement(_app.App, {
          onSuccess: onSuccess
        })), element);
        return () => _reactDom.default.unmountComponentAtNode(element);
      }
    });
  }
  start(_core) {}
}
exports.InteractiveSetupPlugin = InteractiveSetupPlugin;
const Providers = ({
  defaultCode,
  services,
  children
}) => /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, services, /*#__PURE__*/_react.default.createElement(_use_kibana.KibanaProvider, {
  services: services
}, /*#__PURE__*/_react.default.createElement(_use_verification.VerificationProvider, {
  defaultCode: defaultCode
}, children)));
exports.Providers = Providers;