"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatSamples = formatSamples;
exports.generateFields = generateFields;
exports.mergeSamples = mergeSamples;
exports.modifySamples = modifySamples;
var yaml = _interopRequireWildcard(require("js-yaml"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* eslint-disable @typescript-eslint/no-explicit-any */

function modifySamples(state) {
  const modifiedSamples = [];
  const rawSamples = state.rawSamples;
  const packageName = state.packageName;
  const dataStreamName = state.dataStreamName;
  for (const sample of rawSamples) {
    const sampleObj = JSON.parse(sample);
    const newObj = {
      [packageName]: {
        [dataStreamName]: sampleObj
      }
    };
    const modifiedSample = JSON.stringify(newObj);
    modifiedSamples.push(modifiedSample);
  }
  return modifiedSamples;
}
function isEmptyValue(value) {
  return value === null || value === undefined || typeof value === 'object' && !Array.isArray(value) && Object.keys(value).length === 0 || Array.isArray(value) && value.length === 0;
}
function merge(target, source) {
  for (const [key, sourceValue] of Object.entries(source)) {
    const targetValue = target[key];
    if (Array.isArray(sourceValue)) {
      // Directly assign arrays
      target[key] = sourceValue;
    } else if (typeof sourceValue === 'object' && sourceValue !== null && !Array.isArray(targetValue)) {
      if (typeof targetValue !== 'object' || isEmptyValue(targetValue)) {
        target[key] = merge({}, sourceValue);
      } else {
        target[key] = merge(targetValue, sourceValue);
      }
    } else if (!(key in target) || isEmptyValue(targetValue) && !isEmptyValue(sourceValue)) {
      target[key] = sourceValue;
    }
  }
  return target;
}
function mergeSamples(objects) {
  let result = {};
  for (const obj of objects) {
    let sample = obj;
    if (typeof obj === 'string') {
      sample = JSON.parse(obj);
    }
    result = merge(result, sample);
  }
  return JSON.stringify(result, null, 2);
}
function formatSamples(samples) {
  const formattedSamples = [];
  for (const sample of samples) {
    const sampleObj = JSON.parse(sample);
    formattedSamples.push(sampleObj);
  }
  return JSON.stringify(formattedSamples, null, 2);
}
function determineType(value) {
  if (typeof value === 'object' && value !== null) {
    if (Array.isArray(value)) {
      return 'group';
    }
    return 'group';
  }
  if (typeof value === 'string') {
    return 'keyword';
  }
  if (typeof value === 'boolean') {
    return 'boolean';
  }
  if (typeof value === 'number') {
    return 'long';
  }
  return 'keyword'; // Default type for null or other undetermined types
}
function recursiveParse(obj, path) {
  if (typeof obj === 'object' && obj !== null) {
    if (Array.isArray(obj)) {
      // Assume list elements are uniform and use the first element as representative
      if (obj.length > 0) {
        return recursiveParse(obj[0], path);
      }
      return {
        name: path[path.length - 1],
        type: 'group',
        fields: []
      };
    }
    const fields = [];
    for (const [key, value] of Object.entries(obj)) {
      fields.push(recursiveParse(value, path.concat(key)));
    }
    return {
      name: path[path.length - 1],
      type: 'group',
      fields
    };
  }
  return {
    name: path[path.length - 1],
    type: determineType(obj)
  };
}
function generateFields(mergedDocs) {
  const ecsTopKeysSet = new Set(['@timestamp', 'agent', 'as', 'base', 'client', 'cloud', 'code_signature', 'container', 'data_stream', 'destination', 'device', 'dll', 'dns', 'ecs', 'elf', 'email', 'error', 'event', 'faas', 'file', 'geo', 'group', 'hash', 'host', 'http', 'interface', 'labels', 'log', 'macho', 'message', 'network', 'observer', 'orchestrator', 'organization', 'os', 'package', 'pe', 'process', 'registry', 'related', 'risk', 'rule', 'server', 'service', 'source', 'tags', 'threat', 'tls', 'tracing', 'url', 'user', 'user_agent', 'vlan', 'volume', 'vulnerability', 'x509']);
  const doc = JSON.parse(mergedDocs);
  const fieldsStructure = Object.keys(doc).filter(key => !ecsTopKeysSet.has(key)).map(key => recursiveParse(doc[key], [key]));
  return yaml.dump(fieldsStructure, {
    sortKeys: false
  });
}