"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.testPipeline = testPipeline;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function formatSample(sample) {
  const docsTemplate = {
    _index: 'index',
    _id: 'id',
    _source: {
      message: ''
    }
  };
  const formatted = {
    ...docsTemplate
  };
  formatted._source.message = sample;
  return formatted;
}
async function testPipeline(samples, pipeline, client) {
  const docs = samples.map(sample => formatSample(sample));
  const pipelineResults = [];
  const errors = [];
  try {
    const output = await client.asCurrentUser.ingest.simulate({
      docs,
      pipeline
    });
    for (const doc of output.docs) {
      var _doc$doc, _doc$doc$_source, _doc$doc2;
      if ((_doc$doc = doc.doc) !== null && _doc$doc !== void 0 && (_doc$doc$_source = _doc$doc._source) !== null && _doc$doc$_source !== void 0 && _doc$doc$_source.error) {
        errors.push(doc.doc._source.error);
      } else if ((_doc$doc2 = doc.doc) !== null && _doc$doc2 !== void 0 && _doc$doc2._source) {
        pipelineResults.push(doc.doc._source);
      }
    }
  } catch (e) {
    errors.push({
      error: e.message
    });
  }
  return {
    pipelineResults,
    errors
  };
}