"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerIntegrationBuilderRoutes = registerIntegrationBuilderRoutes;
var _common = require("../../common");
var _integration_builder = require("../integration_builder");
var _route_validation = require("../util/route_validation");
var _with_availability = require("./with_availability");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerIntegrationBuilderRoutes(router) {
  router.versioned.post({
    path: _common.INTEGRATION_BUILDER_PATH,
    access: 'internal'
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: (0, _route_validation.buildRouteValidationWithZod)(_common.BuildIntegrationRequestBody)
      }
    }
  }, (0, _with_availability.withAvailability)(async (_, request, response) => {
    const {
      integration
    } = request.body;
    try {
      const zippedIntegration = await (0, _integration_builder.buildPackage)(integration);
      return response.custom({
        statusCode: 200,
        body: zippedIntegration,
        headers: {
          'Content-Type': 'application/zip'
        }
      });
    } catch (e) {
      return response.customError({
        statusCode: 500,
        body: e
      });
    }
  }));
}