"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFieldMapping = createFieldMapping;
var _nunjucks = _interopRequireDefault(require("nunjucks"));
var _util = require("../util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createFieldMapping(packageName, dataStreamName, specificDataStreamDir, docs) {
  createBaseFields(specificDataStreamDir, packageName, dataStreamName);
  createCustomFields(specificDataStreamDir, docs);
}
function createBaseFields(specificDataStreamDir, packageName, dataStreamName) {
  const datasetName = `${packageName}.${dataStreamName}`;
  const baseFields = _nunjucks.default.render('base_fields.yml.njk', {
    module: packageName,
    dataset: datasetName
  });
  (0, _util.createSync)(`${specificDataStreamDir}/base-fields.yml`, baseFields);
}
function createCustomFields(specificDataStreamDir, pipelineResults) {
  const mergedResults = (0, _util.mergeSamples)(pipelineResults);
  const fieldKeys = (0, _util.generateFields)(mergedResults);
  (0, _util.createSync)(`${specificDataStreamDir}/fields/fields.yml`, fieldKeys);
}