"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDataStream = createDataStream;
var _nunjucks = _interopRequireDefault(require("nunjucks"));
var _path = require("path");
var _util = require("../util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createDataStream(packageName, specificDataStreamDir, dataStream) {
  const dataStreamName = dataStream.name;
  const pipelineDir = (0, _path.join)(specificDataStreamDir, 'elasticsearch', 'ingest_pipeline');
  const title = dataStream.title;
  const description = dataStream.description;
  (0, _util.ensureDirSync)(specificDataStreamDir);
  createDataStreamFolders(specificDataStreamDir, pipelineDir);
  createPipelineTests(specificDataStreamDir, dataStream.rawSamples, packageName, dataStreamName);
  const dataStreams = [];
  for (const inputType of dataStream.inputTypes) {
    const mappedValues = {
      data_stream_title: title,
      data_stream_description: description,
      package_name: packageName,
      data_stream_name: dataStreamName
    };
    const dataStreamManifest = _nunjucks.default.render(`${inputType.replaceAll('-', '_')}_manifest.yml.njk`, mappedValues);
    const commonManifest = _nunjucks.default.render('common_manifest.yml.njk', mappedValues);
    const combinedManifest = `${dataStreamManifest}\n${commonManifest}`;
    dataStreams.push(combinedManifest);
  }
  const finalManifest = _nunjucks.default.render('data_stream.yml.njk', {
    title,
    data_streams: dataStreams
  });
  (0, _util.createSync)((0, _path.join)(specificDataStreamDir, 'manifest.yml'), finalManifest);
}
function createDataStreamFolders(specificDataStreamDir, pipelineDir) {
  const dataStreamTemplatesDir = (0, _path.join)(__dirname, '../templates/data_stream');
  const items = (0, _util.listDirSync)(dataStreamTemplatesDir);
  for (const item of items) {
    const s = (0, _path.join)(dataStreamTemplatesDir, item);
    const d = (0, _path.join)(specificDataStreamDir, item);
    (0, _util.copySync)(s, d);
  }
  (0, _util.ensureDirSync)(pipelineDir);
}
function createPipelineTests(specificDataStreamDir, rawSamples, packageName, dataStreamName) {
  const pipelineTestTemplatesDir = (0, _path.join)(__dirname, '../templates/pipeline_tests');
  const pipelineTestsDir = (0, _path.join)(specificDataStreamDir, '_dev/test/pipeline');
  (0, _util.ensureDirSync)(pipelineTestsDir);
  const items = (0, _util.listDirSync)(pipelineTestTemplatesDir);
  for (const item of items) {
    const s = (0, _path.join)(pipelineTestTemplatesDir, item);
    const d = (0, _path.join)(pipelineTestsDir, item.replaceAll('_', '-'));
    (0, _util.copySync)(s, d);
  }
  const formattedPackageName = packageName.replace(/_/g, '-');
  const formattedDataStreamName = dataStreamName.replace(/_/g, '-');
  const testFileName = (0, _path.join)(pipelineTestsDir, `test-${formattedPackageName}-${formattedDataStreamName}.log`);
  (0, _util.createSync)(testFileName, rawSamples.join('\n'));
}