"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleRelated = handleRelated;
var _output_parsers = require("@langchain/core/output_parsers");
var _processors = require("../../util/processors");
var _prompts = require("./prompts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function handleRelated(state, model) {
  const relatedMainPrompt = _prompts.RELATED_MAIN_PROMPT;
  const outputParser = new _output_parsers.JsonOutputParser();
  const relatedMainGraph = relatedMainPrompt.pipe(model).pipe(outputParser);
  const currentProcessors = await relatedMainGraph.invoke({
    pipeline_results: JSON.stringify(state.pipelineResults, null, 2),
    ex_answer: state.exAnswer,
    ecs: state.ecs
  });
  const currentPipeline = (0, _processors.combineProcessors)(state.initialPipeline, currentProcessors);
  return {
    currentPipeline,
    currentProcessors,
    reviewed: false,
    lastExecutedChain: 'related'
  };
}