"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRelatedGraph = getRelatedGraph;
var _langgraph = require("@langchain/langgraph");
var _samples = require("../../util/samples");
var _graph = require("../../util/graph");
var _related = require("./related");
var _errors = require("./errors");
var _review = require("./review");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const graphState = {
  lastExecutedChain: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  rawSamples: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  samples: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  formattedSamples: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  ecs: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  exAnswer: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  packageName: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  dataStreamName: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  finalized: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => false
  },
  reviewed: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => false
  },
  errors: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({})
  },
  pipelineResults: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  currentPipeline: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({})
  },
  currentProcessors: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  initialPipeline: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({})
  },
  results: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({})
  }
};
function modelInput(state) {
  const samples = (0, _samples.modifySamples)(state);
  const formattedSamples = (0, _samples.formatSamples)(samples);
  const initialPipeline = JSON.parse(JSON.stringify(state.currentPipeline));
  return {
    exAnswer: JSON.stringify(_constants.RELATED_EXAMPLE_ANSWER, null, 2),
    ecs: JSON.stringify(_constants.RELATED_ECS_FIELDS, null, 2),
    samples,
    formattedSamples,
    initialPipeline,
    finalized: false,
    reviewed: false,
    lastExecutedChain: 'modelInput'
  };
}
function modelOutput(state) {
  return {
    finalized: true,
    lastExecutedChain: 'modelOutput',
    results: {
      docs: state.pipelineResults,
      pipeline: state.currentPipeline
    }
  };
}
function inputRouter(state) {
  if (Object.keys(state.pipelineResults).length === 0) {
    return 'validatePipeline';
  }
  return 'related';
}
function chainRouter(state) {
  if (Object.keys(state.currentProcessors).length === 0) {
    return 'related';
  }
  if (Object.keys(state.errors).length > 0) {
    return 'errors';
  }
  if (!state.reviewed) {
    return 'review';
  }
  if (!state.finalized) {
    return 'modelOutput';
  }
  return _langgraph.END;
}
async function getRelatedGraph(client, model) {
  const workflow = new _langgraph.StateGraph({
    channels: graphState
  }).addNode('modelInput', modelInput).addNode('modelOutput', modelOutput).addNode('handleRelated', state => (0, _related.handleRelated)(state, model)).addNode('handleValidatePipeline', state => (0, _graph.handleValidatePipeline)(state, client)).addNode('handleErrors', state => (0, _errors.handleErrors)(state, model)).addNode('handleReview', state => (0, _review.handleReview)(state, model)).addEdge(_langgraph.START, 'modelInput').addEdge('modelOutput', _langgraph.END).addEdge('handleRelated', 'handleValidatePipeline').addEdge('handleErrors', 'handleValidatePipeline').addEdge('handleReview', 'handleValidatePipeline').addConditionalEdges('modelInput', inputRouter, {
    related: 'handleRelated',
    validatePipeline: 'handleValidatePipeline'
  }).addConditionalEdges('handleValidatePipeline', chainRouter, {
    related: 'handleRelated',
    errors: 'handleErrors',
    review: 'handleReview',
    modelOutput: 'modelOutput'
  });
  const compiledRelatedGraph = workflow.compile();
  return compiledRelatedGraph;
}