"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleMissingKeys = handleMissingKeys;
var _output_parsers = require("@langchain/core/output_parsers");
var _prompts = require("./prompts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function handleMissingKeys(state, model) {
  const ecsMissingPrompt = _prompts.ECS_MISSING_KEYS_PROMPT;
  const outputParser = new _output_parsers.JsonOutputParser();
  const ecsMissingGraph = ecsMissingPrompt.pipe(model).pipe(outputParser);
  const currentMapping = await ecsMissingGraph.invoke({
    ecs: state.ecs,
    current_mapping: JSON.stringify(state.currentMapping, null, 2),
    ex_answer: state.exAnswer,
    formatted_samples: state.formattedSamples,
    missing_keys: state === null || state === void 0 ? void 0 : state.missingKeys
  });
  return {
    currentMapping,
    lastExecutedChain: 'missingKeys'
  };
}