"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleEcsMapping = handleEcsMapping;
var _output_parsers = require("@langchain/core/output_parsers");
var _prompts = require("./prompts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function handleEcsMapping(state, model) {
  const ecsMainPrompt = _prompts.ECS_MAIN_PROMPT;
  const outputParser = new _output_parsers.JsonOutputParser();
  const ecsMainGraph = ecsMainPrompt.pipe(model).pipe(outputParser);
  const currentMapping = await ecsMainGraph.invoke({
    ecs: state.ecs,
    formatted_samples: state.formattedSamples,
    package_name: state.packageName,
    data_stream_name: state.dataStreamName,
    ex_answer: state.exAnswer
  });
  return {
    currentMapping,
    lastExecutedChain: 'ecsMapping'
  };
}