"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleInvalidEcs = handleInvalidEcs;
var _output_parsers = require("@langchain/core/output_parsers");
var _prompts = require("./prompts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function handleInvalidEcs(state, model) {
  const ecsInvalidEcsPrompt = _prompts.ECS_INVALID_PROMPT;
  const outputParser = new _output_parsers.JsonOutputParser();
  const ecsInvalidEcsGraph = ecsInvalidEcsPrompt.pipe(model).pipe(outputParser);
  const currentMapping = await ecsInvalidEcsGraph.invoke({
    ecs: state.ecs,
    current_mapping: JSON.stringify(state.currentMapping, null, 2),
    ex_answer: state.exAnswer,
    formatted_samples: state.formattedSamples,
    invalid_ecs_fields: state.invalidEcsFields
  });
  return {
    currentMapping,
    lastExecutedChain: 'invalidEcs'
  };
}