"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEcsGraph = getEcsGraph;
var _langgraph = require("@langchain/langgraph");
var _samples = require("../../util/samples");
var _constants = require("./constants");
var _duplicates = require("./duplicates");
var _invalid = require("./invalid");
var _mapping = require("./mapping");
var _missing = require("./missing");
var _pipeline = require("./pipeline");
var _validate = require("./validate");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const graphState = {
  ecs: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  lastExecutedChain: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  rawSamples: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  samples: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  formattedSamples: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  exAnswer: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  packageName: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  dataStreamName: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  finalized: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => false
  },
  currentMapping: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({})
  },
  currentPipeline: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({})
  },
  duplicateFields: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  missingKeys: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  invalidEcsFields: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  results: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({})
  },
  logFormat: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => 'json'
  },
  ecsVersion: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => '8.11.0'
  }
};
function modelInput(state) {
  const samples = (0, _samples.modifySamples)(state);
  const formattedSamples = (0, _samples.mergeSamples)(samples);
  return {
    exAnswer: JSON.stringify(_constants.ECS_EXAMPLE_ANSWER, null, 2),
    ecs: JSON.stringify(_constants.ECS_FIELDS, null, 2),
    samples,
    finalized: false,
    formattedSamples,
    lastExecutedChain: 'modelInput'
  };
}
function modelOutput(state) {
  const currentPipeline = (0, _pipeline.createPipeline)(state);
  return {
    finalized: true,
    lastExecutedChain: 'modelOutput',
    results: {
      mapping: state.currentMapping,
      pipeline: currentPipeline
    }
  };
}
function inputRouter(state) {
  if (Object.keys(state.currentMapping).length === 0) {
    return 'ecsMapping';
  }
  return 'modelOutput';
}
function chainRouter(state) {
  if (Object.keys(state.duplicateFields).length > 0) {
    return 'duplicateFields';
  }
  if (Object.keys(state.missingKeys).length > 0) {
    return 'missingKeys';
  }
  if (Object.keys(state.invalidEcsFields).length > 0) {
    return 'invalidEcsFields';
  }
  if (!state.finalized) {
    return 'modelOutput';
  }
  return _langgraph.END;
}
async function getEcsGraph(model) {
  const workflow = new _langgraph.StateGraph({
    channels: graphState
  }).addNode('modelInput', modelInput).addNode('modelOutput', modelOutput).addNode('handleEcsMapping', state => (0, _mapping.handleEcsMapping)(state, model)).addNode('handleValidation', _validate.handleValidateMappings).addNode('handleDuplicates', state => (0, _duplicates.handleDuplicates)(state, model)).addNode('handleMissingKeys', state => (0, _missing.handleMissingKeys)(state, model)).addNode('handleInvalidEcs', state => (0, _invalid.handleInvalidEcs)(state, model)).addEdge(_langgraph.START, 'modelInput').addEdge('modelOutput', _langgraph.END).addEdge('handleEcsMapping', 'handleValidation').addEdge('handleDuplicates', 'handleValidation').addEdge('handleMissingKeys', 'handleValidation').addEdge('handleInvalidEcs', 'handleValidation').addConditionalEdges('modelInput', inputRouter, {
    ecsMapping: 'handleEcsMapping',
    modelOutput: 'modelOutput'
  }).addConditionalEdges('handleValidation', chainRouter, {
    duplicateFields: 'handleDuplicates',
    missingKeys: 'handleMissingKeys',
    invalidEcsFields: 'handleInvalidEcs',
    modelOutput: 'modelOutput'
  });
  const compiledEcsGraph = workflow.compile();
  return compiledEcsGraph;
}