"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleDuplicates = handleDuplicates;
var _output_parsers = require("@langchain/core/output_parsers");
var _prompts = require("./prompts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function handleDuplicates(state, model) {
  const ecsDuplicatesPrompt = _prompts.ECS_DUPLICATES_PROMPT;
  const outputParser = new _output_parsers.JsonOutputParser();
  const ecsDuplicatesGraph = ecsDuplicatesPrompt.pipe(model).pipe(outputParser);
  const currentMapping = await ecsDuplicatesGraph.invoke({
    ecs: state.ecs,
    current_mapping: JSON.stringify(state.currentMapping, null, 2),
    ex_answer: state.exAnswer,
    duplicate_fields: state.duplicateFields
  });
  return {
    currentMapping,
    lastExecutedChain: 'duplicateFields'
  };
}