"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCategorizationGraph = getCategorizationGraph;
var _langgraph = require("@langchain/langgraph");
var _samples = require("../../util/samples");
var _categorization = require("./categorization");
var _graph = require("../../util/graph");
var _validate = require("./validate");
var _invalid = require("./invalid");
var _errors = require("./errors");
var _review = require("./review");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const graphState = {
  lastExecutedChain: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  rawSamples: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  samples: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  formattedSamples: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  ecsTypes: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  ecsCategories: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  exAnswer: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  packageName: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  dataStreamName: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  finalized: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => false
  },
  reviewed: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => false
  },
  errors: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({})
  },
  pipelineResults: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => [{}]
  },
  currentPipeline: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({})
  },
  currentProcessors: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  invalidCategorization: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({})
  },
  initialPipeline: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({})
  },
  results: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({})
  }
};
function modelInput(state) {
  const samples = (0, _samples.modifySamples)(state);
  const formattedSamples = (0, _samples.formatSamples)(samples);
  const initialPipeline = JSON.parse(JSON.stringify(state.currentPipeline));
  return {
    exAnswer: JSON.stringify(_constants.CATEGORIZATION_EXAMPLE_ANSWER, null, 2),
    ecsCategories: JSON.stringify(_constants.ECS_CATEGORIES, null, 2),
    ecsTypes: JSON.stringify(_constants.ECS_TYPES, null, 2),
    samples,
    formattedSamples,
    initialPipeline,
    finalized: false,
    reviewed: false,
    lastExecutedChain: 'modelInput'
  };
}
function modelOutput(state) {
  return {
    finalized: true,
    lastExecutedChain: 'modelOutput',
    results: {
      docs: state.pipelineResults,
      pipeline: state.currentPipeline
    }
  };
}
function validationRouter(state) {
  if (Object.keys(state.currentProcessors).length === 0) {
    return 'categorization';
  }
  return 'validateCategorization';
}
function chainRouter(state) {
  if (Object.keys(state.errors).length > 0) {
    return 'errors';
  }
  if (Object.keys(state.invalidCategorization).length > 0) {
    return 'invalidCategorization';
  }
  if (!state.reviewed) {
    return 'review';
  }
  if (!state.finalized) {
    return 'modelOutput';
  }
  return _langgraph.END;
}
async function getCategorizationGraph(client, model) {
  const workflow = new _langgraph.StateGraph({
    channels: graphState
  }).addNode('modelInput', modelInput).addNode('modelOutput', modelOutput).addNode('handleCategorization', state => (0, _categorization.handleCategorization)(state, model)).addNode('handleValidatePipeline', state => (0, _graph.handleValidatePipeline)(state, client)).addNode('handleCategorizationValidation', _validate.handleCategorizationValidation).addNode('handleInvalidCategorization', state => (0, _invalid.handleInvalidCategorization)(state, model)).addNode('handleErrors', state => (0, _errors.handleErrors)(state, model)).addNode('handleReview', state => (0, _review.handleReview)(state, model)).addEdge(_langgraph.START, 'modelInput').addEdge('modelOutput', _langgraph.END).addEdge('modelInput', 'handleValidatePipeline').addEdge('handleCategorization', 'handleValidatePipeline').addEdge('handleInvalidCategorization', 'handleValidatePipeline').addEdge('handleErrors', 'handleValidatePipeline').addEdge('handleReview', 'handleValidatePipeline').addConditionalEdges('handleValidatePipeline', validationRouter, {
    categorization: 'handleCategorization',
    validateCategorization: 'handleCategorizationValidation'
  }).addConditionalEdges('handleCategorizationValidation', chainRouter, {
    modelOutput: 'modelOutput',
    errors: 'handleErrors',
    invalidCategorization: 'handleInvalidCategorization',
    review: 'handleReview'
  });
  const compiledCategorizationGraph = workflow.compile();
  return compiledCategorizationGraph;
}