"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCheckPipeline = void 0;
var _public = require("@kbn/kibana-react-plugin/public");
var _fp = require("lodash/fp");
var _react = require("react");
var _state = require("../../state");
var _api = require("../../../../../common/lib/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCheckPipeline = ({
  integrationSettings,
  customPipeline
}) => {
  const {
    http,
    notifications
  } = (0, _public.useKibana)().services;
  const {
    setIsGenerating,
    setResult
  } = (0, _state.useActions)();
  const [error, setError] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    if (customPipeline == null || http == null || integrationSettings == null || (notifications === null || notifications === void 0 ? void 0 : notifications.toasts) == null) {
      return;
    }
    const abortController = new AbortController();
    const deps = {
      http,
      abortSignal: abortController.signal
    };
    (async () => {
      try {
        var _integrationSettings$;
        const parameters = {
          pipeline: customPipeline,
          rawSamples: (_integrationSettings$ = integrationSettings.logsSampleParsed) !== null && _integrationSettings$ !== void 0 ? _integrationSettings$ : []
        };
        setIsGenerating(true);
        const checkPipelineResults = await (0, _api.runCheckPipelineResults)(parameters, deps);
        if (abortController.signal.aborted) return;
        if ((0, _fp.isEmpty)(checkPipelineResults === null || checkPipelineResults === void 0 ? void 0 : checkPipelineResults.results.docs)) {
          setError('No results for the pipeline');
          return;
        }
        setResult({
          pipeline: customPipeline,
          docs: checkPipelineResults.results.docs
        });
      } catch (e) {
        var _e$body$message, _e$body;
        if (abortController.signal.aborted) return;
        setError(`Error: ${(_e$body$message = (_e$body = e.body) === null || _e$body === void 0 ? void 0 : _e$body.message) !== null && _e$body$message !== void 0 ? _e$body$message : e.message}`);
      } finally {
        setIsGenerating(false);
      }
    })();
    return () => {
      abortController.abort();
    };
  }, [setIsGenerating, http, integrationSettings, notifications === null || notifications === void 0 ? void 0 : notifications.toasts, setResult, customPipeline]);
  return {
    error
  };
};
exports.useCheckPipeline = useCheckPipeline;