"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLoadPackageNames = void 0;
var _react = require("react");
var _use_kibana = require("../../../../../common/hooks/use_kibana");
var _api = require("../../../../../common/lib/api");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLoadPackageNames = () => {
  const {
    http,
    notifications
  } = (0, _use_kibana.useKibana)().services;
  const [packageNames, setPackageNames] = (0, _react.useState)();
  const [isLoading, setIsLoading] = (0, _react.useState)(true);
  (0, _react.useEffect)(() => {
    const abortController = new AbortController();
    const deps = {
      http,
      abortSignal: abortController.signal
    };
    (async () => {
      try {
        var _packagesResponse$res;
        setIsLoading(true);
        const packagesResponse = await (0, _api.getInstalledPackages)(deps);
        if (abortController.signal.aborted) return;
        if (!(packagesResponse !== null && packagesResponse !== void 0 && (_packagesResponse$res = packagesResponse.response) !== null && _packagesResponse$res !== void 0 && _packagesResponse$res.length)) {
          throw Error('No packages found');
        }
        setPackageNames(new Set(packagesResponse.response.map(pkg => pkg.name)));
      } catch (e) {
        if (!abortController.signal.aborted) {
          notifications === null || notifications === void 0 ? void 0 : notifications.toasts.addError(e, {
            title: i18n.PACKAGE_NAMES_FETCH_ERROR
          });
        }
      } finally {
        setIsLoading(false);
      }
    })();
    return () => {
      abortController.abort();
    };
  }, [http, notifications]);
  return {
    isLoading,
    packageNames
  };
};
exports.useLoadPackageNames = useLoadPackageNames;