"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RETRY = exports.PROGRESS_RELATED_GRAPH = exports.PROGRESS_ECS_MAPPING = exports.PROGRESS_CATEGORIZATION = exports.PACKAGE_NAMES_FETCH_ERROR = exports.NO_SPACES_HELP = exports.NAME_ALREADY_EXISTS_ERROR = exports.LOGS_SAMPLE_WARNING = exports.LOGS_SAMPLE_TRUNCATED = exports.LOGS_SAMPLE_LABEL = exports.LOGS_SAMPLE_ERROR = exports.LOGS_SAMPLE_DESCRIPTION_2 = exports.LOGS_SAMPLE_DESCRIPTION = exports.INTEGRATION_NAME_TITLE = exports.INTEGRATION_NAME_LABEL = exports.INTEGRATION_NAME_DESCRIPTION = exports.GENERATION_ERROR = exports.DATA_STREAM_TITLE_LABEL = exports.DATA_STREAM_TITLE = exports.DATA_STREAM_NAME_LABEL = exports.DATA_STREAM_DESCRIPTION_LABEL = exports.DATA_STREAM_DESCRIPTION = exports.DATA_COLLECTION_METHOD_LABEL = exports.ANALYZING = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INTEGRATION_NAME_TITLE = exports.INTEGRATION_NAME_TITLE = _i18n.i18n.translate('xpack.integrationAssistant.step.dataStream.integrationNameTitle', {
  defaultMessage: 'Define package name'
});
const INTEGRATION_NAME_DESCRIPTION = exports.INTEGRATION_NAME_DESCRIPTION = _i18n.i18n.translate('xpack.integrationAssistant.step.dataStream.integrationNameDescription', {
  defaultMessage: "The package name is used to refer to the integration in Elastic's ingest pipeline"
});
const DATA_STREAM_TITLE = exports.DATA_STREAM_TITLE = _i18n.i18n.translate('xpack.integrationAssistant.step.dataStream.dataStreamTitle', {
  defaultMessage: 'Define data stream and upload logs'
});
const DATA_STREAM_DESCRIPTION = exports.DATA_STREAM_DESCRIPTION = _i18n.i18n.translate('xpack.integrationAssistant.step.dataStream.dataStreamDescription', {
  defaultMessage: 'Logs are analyzed to automatically map ECS fields and help create the ingestion pipeline'
});
const INTEGRATION_NAME_LABEL = exports.INTEGRATION_NAME_LABEL = _i18n.i18n.translate('xpack.integrationAssistant.step.dataStream.integrationName.label', {
  defaultMessage: 'Integration package name'
});
const NO_SPACES_HELP = exports.NO_SPACES_HELP = _i18n.i18n.translate('xpack.integrationAssistant.step.dataStream.noSpacesHelpText', {
  defaultMessage: 'Name can only contain lowercase letters, numbers, and underscore (_)'
});
const PACKAGE_NAMES_FETCH_ERROR = exports.PACKAGE_NAMES_FETCH_ERROR = _i18n.i18n.translate('xpack.integrationAssistant.step.dataStream.packageNamesFetchError', {
  defaultMessage: 'Error fetching package names'
});
const NAME_ALREADY_EXISTS_ERROR = exports.NAME_ALREADY_EXISTS_ERROR = _i18n.i18n.translate('xpack.integrationAssistant.step.dataStream.nameAlreadyExistsError', {
  defaultMessage: 'This integration name is already in use. Please choose a different name.'
});
const DATA_STREAM_TITLE_LABEL = exports.DATA_STREAM_TITLE_LABEL = _i18n.i18n.translate('xpack.integrationAssistant.step.dataStream.dataStreamTitle.label', {
  defaultMessage: 'Data stream title'
});
const DATA_STREAM_DESCRIPTION_LABEL = exports.DATA_STREAM_DESCRIPTION_LABEL = _i18n.i18n.translate('xpack.integrationAssistant.step.dataStream.dataStreamDescription.label', {
  defaultMessage: 'Data stream description'
});
const DATA_STREAM_NAME_LABEL = exports.DATA_STREAM_NAME_LABEL = _i18n.i18n.translate('xpack.integrationAssistant.step.dataStream.dataStreamName.label', {
  defaultMessage: 'Data stream name'
});
const DATA_COLLECTION_METHOD_LABEL = exports.DATA_COLLECTION_METHOD_LABEL = _i18n.i18n.translate('xpack.integrationAssistant.step.dataStream.dataCollectionMethod.label', {
  defaultMessage: 'Data collection method'
});
const LOGS_SAMPLE_LABEL = exports.LOGS_SAMPLE_LABEL = _i18n.i18n.translate('xpack.integrationAssistant.step.dataStream.logsSample.label', {
  defaultMessage: 'Logs'
});
const LOGS_SAMPLE_WARNING = exports.LOGS_SAMPLE_WARNING = _i18n.i18n.translate('xpack.integrationAssistant.step.dataStream.logsSample.warning', {
  defaultMessage: 'Please note that this data will be analyzed by a third-party AI tool. Ensure that you comply with privacy and security guidelines when selecting data.'
});
const LOGS_SAMPLE_DESCRIPTION = exports.LOGS_SAMPLE_DESCRIPTION = _i18n.i18n.translate('xpack.integrationAssistant.step.dataStream.logsSample.description', {
  defaultMessage: 'Drag and drop a file or Browse files.'
});
const LOGS_SAMPLE_DESCRIPTION_2 = exports.LOGS_SAMPLE_DESCRIPTION_2 = _i18n.i18n.translate('xpack.integrationAssistant.step.dataStream.logsSample.description2', {
  defaultMessage: 'JSON/NDJSON format'
});
const LOGS_SAMPLE_TRUNCATED = maxRows => _i18n.i18n.translate('xpack.integrationAssistant.step.dataStream.logsSample.truncatedWarning', {
  values: {
    maxRows
  },
  defaultMessage: `The logs sample has been truncated to {maxRows} rows.`
});
exports.LOGS_SAMPLE_TRUNCATED = LOGS_SAMPLE_TRUNCATED;
const LOGS_SAMPLE_ERROR = exports.LOGS_SAMPLE_ERROR = {
  CAN_NOT_READ: _i18n.i18n.translate('xpack.integrationAssistant.step.dataStream.logsSample.errorCanNotRead', {
    defaultMessage: 'Failed to read the logs sample file'
  }),
  FORMAT: fileType => _i18n.i18n.translate('xpack.integrationAssistant.step.dataStream.logsSample.errorFormat', {
    values: {
      fileType
    },
    defaultMessage: 'The logs sample file has not a valid {fileType} format'
  }),
  NOT_ARRAY: _i18n.i18n.translate('xpack.integrationAssistant.step.dataStream.logsSample.errorNotArray', {
    defaultMessage: 'The logs sample file is not an array'
  }),
  EMPTY: _i18n.i18n.translate('xpack.integrationAssistant.step.dataStream.logsSample.errorEmpty', {
    defaultMessage: 'The logs sample file is empty'
  }),
  NOT_OBJECT: _i18n.i18n.translate('xpack.integrationAssistant.step.dataStream.logsSample.errorNotObject', {
    defaultMessage: 'The logs sample file contains non-object entries'
  })
};
const ANALYZING = exports.ANALYZING = _i18n.i18n.translate('xpack.integrationAssistant.step.dataStream.analyzing', {
  defaultMessage: 'Analyzing'
});
const PROGRESS_ECS_MAPPING = exports.PROGRESS_ECS_MAPPING = _i18n.i18n.translate('xpack.integrationAssistant.step.dataStream.progress.ecsMapping', {
  defaultMessage: 'Mapping ECS fields'
});
const PROGRESS_CATEGORIZATION = exports.PROGRESS_CATEGORIZATION = _i18n.i18n.translate('xpack.integrationAssistant.step.dataStream.progress.categorization', {
  defaultMessage: 'Adding categorization'
});
const PROGRESS_RELATED_GRAPH = exports.PROGRESS_RELATED_GRAPH = _i18n.i18n.translate('xpack.integrationAssistant.step.dataStream.progress.relatedGraph', {
  defaultMessage: 'Generating related fields'
});
const GENERATION_ERROR = progressStep => _i18n.i18n.translate('xpack.integrationAssistant.step.dataStream.generationError', {
  values: {
    progressStep
  },
  defaultMessage: 'An error occurred during: {progressStep}'
});
exports.GENERATION_ERROR = GENERATION_ERROR;
const RETRY = exports.RETRY = _i18n.i18n.translate('xpack.integrationAssistant.step.dataStream.retryButtonLabel', {
  defaultMessage: 'Retry'
});