"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SampleLogsInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _fp = require("lodash/fp");
var i18n = _interopRequireWildcard(require("./translations"));
var _state = require("../../state");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MaxLogsSampleRows = 10;

/**
 * Parse the logs sample file content (json or ndjson) and return the parsed logs sample
 */
const parseLogsContent = (fileContent, fileType) => {
  if (fileContent == null) {
    return {
      error: i18n.LOGS_SAMPLE_ERROR.CAN_NOT_READ
    };
  }
  let parsedContent;
  try {
    if (fileType === 'application/json') {
      parsedContent = JSON.parse(fileContent);
    } else if (fileType === 'application/x-ndjson') {
      parsedContent = fileContent.split('\n').filter(line => line.trim() !== '').map(line => JSON.parse(line));
    }
  } catch (_) {
    return {
      error: i18n.LOGS_SAMPLE_ERROR.FORMAT(fileType)
    };
  }
  if (!Array.isArray(parsedContent)) {
    return {
      error: i18n.LOGS_SAMPLE_ERROR.NOT_ARRAY
    };
  }
  if (parsedContent.length === 0) {
    return {
      error: i18n.LOGS_SAMPLE_ERROR.EMPTY
    };
  }
  let isTruncated = false;
  if (parsedContent.length > MaxLogsSampleRows) {
    parsedContent = parsedContent.slice(0, MaxLogsSampleRows);
    isTruncated = true;
  }
  if (parsedContent.some(log => !(0, _fp.isPlainObject)(log))) {
    return {
      error: i18n.LOGS_SAMPLE_ERROR.NOT_OBJECT
    };
  }
  const logsSampleParsed = parsedContent.map(log => JSON.stringify(log));
  return {
    isTruncated,
    logsSampleParsed
  };
};
const SampleLogsInput = exports.SampleLogsInput = /*#__PURE__*/_react.default.memo(({
  integrationSettings
}) => {
  const {
    notifications
  } = (0, _public.useKibana)().services;
  const {
    setIntegrationSettings
  } = (0, _state.useActions)();
  const [isParsing, setIsParsing] = (0, _react.useState)(false);
  const [sampleFileError, setSampleFileError] = (0, _react.useState)();
  const onChangeLogsSample = (0, _react.useCallback)(files => {
    const logsSampleFile = files === null || files === void 0 ? void 0 : files[0];
    if (logsSampleFile == null) {
      setSampleFileError(undefined);
      setIntegrationSettings({
        ...integrationSettings,
        logsSampleParsed: undefined
      });
      return;
    }
    const reader = new FileReader();
    reader.onload = function (e) {
      var _e$target;
      const fileContent = (_e$target = e.target) === null || _e$target === void 0 ? void 0 : _e$target.result; // We can safely cast to string since we call `readAsText` to load the file.
      const {
        error,
        isTruncated,
        logsSampleParsed
      } = parseLogsContent(fileContent, logsSampleFile.type);
      setIsParsing(false);
      setSampleFileError(error);
      if (error) {
        setIntegrationSettings({
          ...integrationSettings,
          logsSampleParsed: undefined
        });
        return;
      }
      if (isTruncated) {
        notifications === null || notifications === void 0 ? void 0 : notifications.toasts.addInfo(i18n.LOGS_SAMPLE_TRUNCATED(MaxLogsSampleRows));
      }
      setIntegrationSettings({
        ...integrationSettings,
        logsSampleParsed
      });
    };
    setIsParsing(true);
    reader.readAsText(logsSampleFile);
  }, [integrationSettings, setIntegrationSettings, notifications === null || notifications === void 0 ? void 0 : notifications.toasts, setIsParsing]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.LOGS_SAMPLE_LABEL,
    helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "danger",
      size: "xs"
    }, sampleFileError),
    isInvalid: sampleFileError != null
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "iInCircle",
    color: "warning"
  }, i18n.LOGS_SAMPLE_WARNING), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    id: "logsSampleFilePicker",
    initialPromptText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      textAlign: "center"
    }, i18n.LOGS_SAMPLE_DESCRIPTION), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      textAlign: "center"
    }, i18n.LOGS_SAMPLE_DESCRIPTION_2)),
    onChange: onChangeLogsSample,
    display: "large",
    "aria-label": "Upload logs sample file",
    accept: "application/json,application/x-ndjson",
    isLoading: isParsing,
    "data-test-subj": "logsSampleFilePicker",
    "data-loading": isParsing
  })));
});
SampleLogsInput.displayName = 'SampleLogsInput';