"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _elasticAssistant = require("@kbn/elastic-assistant");
var _eui = require("@elastic/eui");
var _authorization = require("../../../../../common/components/authorization");
var _use_authorization = require("../../../../../common/hooks/use_authorization");
var _use_kibana = require("../../../../../common/hooks/use_kibana");
var _step_content_wrapper = require("../step_content_wrapper");
var _connector_selector = require("./connector_selector");
var _connector_setup = require("./connector_setup");
var _state = require("../../state");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * List of allowed action type IDs for the integrations assistant.
 */
const AllowedActionTypeIds = ['.bedrock'];
const ConnectorStep = exports.ConnectorStep = /*#__PURE__*/_react.default.memo(({
  connector
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    http,
    notifications
  } = (0, _use_kibana.useKibana)().services;
  const {
    setConnector
  } = (0, _state.useActions)();
  const [connectors, setConnectors] = (0, _react.useState)();
  const {
    isLoading,
    data: aiConnectors,
    refetch: refetchConnectors
  } = (0, _elasticAssistant.useLoadConnectors)({
    http,
    toasts: notifications.toasts
  });
  (0, _react.useEffect)(() => {
    if (aiConnectors != null) {
      // filter out connectors, this is temporary until we add support for more models
      const filteredAiConnectors = aiConnectors.filter(({
        actionTypeId
      }) => AllowedActionTypeIds.includes(actionTypeId));
      setConnectors(filteredAiConnectors);
      if (filteredAiConnectors && filteredAiConnectors.length === 1) {
        // pre-select the connector if there is only one
        setConnector(filteredAiConnectors[0]);
      }
    }
  }, [aiConnectors, setConnector]);
  const onConnectorSaved = (0, _react.useCallback)(() => refetchConnectors(), [refetchConnectors]);
  const hasConnectors = !isLoading && (connectors === null || connectors === void 0 ? void 0 : connectors.length);
  return /*#__PURE__*/_react.default.createElement(_step_content_wrapper.StepContentWrapper, {
    title: i18n.TITLE,
    subtitle: i18n.DESCRIPTION,
    right: hasConnectors ? /*#__PURE__*/_react.default.createElement(CreateConnectorPopover, {
      onConnectorSaved: onConnectorSaved
    }) : null
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "stretch"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasConnectors ? /*#__PURE__*/_react.default.createElement(_connector_selector.ConnectorSelector, {
    connectors: connectors,
    selectedConnectorId: connector === null || connector === void 0 ? void 0 : connector.id
  }) : /*#__PURE__*/_react.default.createElement(_authorization.AuthorizationWrapper, {
    canCreateConnectors: true
  }, /*#__PURE__*/_react.default.createElement(_connector_setup.ConnectorSetup, {
    actionTypeIds: AllowedActionTypeIds,
    onConnectorSaved: onConnectorSaved
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xs",
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      margin: euiTheme.size.xxs
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "iInCircle"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, i18n.SUPPORTED_MODELS_INFO))));
});
ConnectorStep.displayName = 'ConnectorStep';
const CreateConnectorPopover = /*#__PURE__*/_react.default.memo(({
  onConnectorSaved
}) => {
  const {
    canCreateConnectors
  } = (0, _use_authorization.useAuthorization)();
  const [isOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const openPopover = (0, _react.useCallback)(() => setIsPopoverOpen(true), []);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  const onConnectorSavedAndClose = (0, _react.useCallback)(() => {
    onConnectorSaved();
    closePopover();
  }, [onConnectorSaved, closePopover]);
  if (!canCreateConnectors) {
    return /*#__PURE__*/_react.default.createElement(_authorization.MissingPrivilegesTooltip, {
      canCreateConnectors: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "createConnectorPopoverButtonDisabled",
      disabled: true
    }, i18n.CREATE_CONNECTOR));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "createConnectorPopoverButton",
      onClick: openPopover
    }, i18n.CREATE_CONNECTOR)),
    isOpen: isOpen,
    closePopover: closePopover,
    "data-test-subj": "createConnectorPopover"
  }, /*#__PURE__*/_react.default.createElement(_connector_setup.ConnectorSetup, {
    actionTypeIds: AllowedActionTypeIds,
    onConnectorSaved: onConnectorSavedAndClose,
    onClose: closePopover,
    compressed: true
  }));
});
CreateConnectorPopover.displayName = 'CreateConnectorPopover';