"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Footer = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _buttons_footer = require("../../../../common/components/buttons_footer");
var _use_navigate = require("../../../../common/hooks/use_navigate");
var _telemetry = require("../../telemetry");
var _state = require("../state");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Generation button for Step 3
const AnalyzeButtonText = /*#__PURE__*/_react.default.memo(({
  isGenerating
}) => {
  if (!isGenerating) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.ANALYZE_LOGS);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s",
    "data-test-subj": "generatingLoader"
  }), i18n.LOADING);
});
AnalyzeButtonText.displayName = 'AnalyzeButtonText';
const Footer = exports.Footer = /*#__PURE__*/_react.default.memo(({
  currentStep,
  isGenerating,
  isNextStepEnabled = false
}) => {
  const telemetry = (0, _telemetry.useTelemetry)();
  const {
    setStep,
    setIsGenerating
  } = (0, _state.useActions)();
  const navigate = (0, _use_navigate.useNavigate)();
  const onBack = (0, _react.useCallback)(() => {
    if (currentStep === 1) {
      navigate(_use_navigate.Page.landing);
    } else {
      setStep(currentStep - 1);
    }
  }, [currentStep, navigate, setStep]);
  const onNext = (0, _react.useCallback)(() => {
    telemetry.reportAssistantStepComplete({
      step: currentStep
    });
    if (currentStep === 3) {
      setIsGenerating(true);
    } else {
      setStep(currentStep + 1);
    }
  }, [currentStep, setIsGenerating, setStep, telemetry]);
  const nextButtonText = (0, _react.useMemo)(() => {
    if (currentStep === 3) {
      return /*#__PURE__*/_react.default.createElement(AnalyzeButtonText, {
        isGenerating: isGenerating
      });
    }
    if (currentStep === 4) {
      return i18n.ADD_TO_ELASTIC;
    }
  }, [currentStep, isGenerating]);
  if (currentStep === 5) {
    return /*#__PURE__*/_react.default.createElement(_buttons_footer.ButtonsFooter, {
      cancelButtonText: i18n.CLOSE
    });
  }
  return /*#__PURE__*/_react.default.createElement(_buttons_footer.ButtonsFooter, {
    isNextDisabled: !isNextStepEnabled || isGenerating,
    onBack: onBack,
    onNext: onNext,
    nextButtonText: nextButtonText
  });
});
Footer.displayName = 'Footer';