"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateIntegrationAssistant = void 0;
var _react = _interopRequireWildcard(require("react"));
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _header = require("./header");
var _footer = require("./footer");
var _connector_step = require("./steps/connector_step");
var _integration_step = require("./steps/integration_step");
var _data_stream_step = require("./steps/data_stream_step");
var _review_step = require("./steps/review_step");
var _deploy_step = require("./steps/deploy_step");
var _state = require("./state");
var _telemetry = require("../telemetry");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateIntegrationAssistant = exports.CreateIntegrationAssistant = /*#__PURE__*/_react.default.memo(() => {
  const [state, dispatch] = (0, _react.useReducer)(_state.reducer, _state.initialState);
  const telemetry = (0, _telemetry.useTelemetry)();
  (0, _react.useEffect)(() => {
    telemetry.reportAssistantOpen();
  }, [telemetry]);
  const actions = (0, _react.useMemo)(() => ({
    setStep: payload => {
      dispatch({
        type: 'SET_STEP',
        payload
      });
    },
    setConnector: payload => {
      dispatch({
        type: 'SET_CONNECTOR',
        payload
      });
    },
    setIntegrationSettings: payload => {
      dispatch({
        type: 'SET_INTEGRATION_SETTINGS',
        payload
      });
    },
    setIsGenerating: payload => {
      dispatch({
        type: 'SET_IS_GENERATING',
        payload
      });
    },
    setResult: payload => {
      dispatch({
        type: 'SET_GENERATED_RESULT',
        payload
      });
    }
  }), []);
  const isNextStepEnabled = (0, _react.useMemo)(() => {
    if (state.step === 1) {
      return (0, _connector_step.isConnectorStepReady)(state);
    } else if (state.step === 2) {
      return (0, _integration_step.isIntegrationStepReady)(state);
    } else if (state.step === 3) {
      return (0, _data_stream_step.isDataStreamStepReady)(state);
    } else if (state.step === 4) {
      return (0, _review_step.isReviewStepReady)(state);
    }
    return false;
  }, [state]);
  return /*#__PURE__*/_react.default.createElement(_state.ActionsProvider, {
    value: actions
  }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, null, /*#__PURE__*/_react.default.createElement(_header.Header, {
    currentStep: state.step,
    isGenerating: state.isGenerating
  }), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    grow: true,
    paddingSize: "l"
  }, state.step === 1 && /*#__PURE__*/_react.default.createElement(_connector_step.ConnectorStep, {
    connector: state.connector
  }), state.step === 2 && /*#__PURE__*/_react.default.createElement(_integration_step.IntegrationStep, {
    integrationSettings: state.integrationSettings
  }), state.step === 3 && /*#__PURE__*/_react.default.createElement(_data_stream_step.DataStreamStep, {
    integrationSettings: state.integrationSettings,
    connector: state.connector,
    isGenerating: state.isGenerating
  }), state.step === 4 && /*#__PURE__*/_react.default.createElement(_review_step.ReviewStep, {
    integrationSettings: state.integrationSettings,
    isGenerating: state.isGenerating,
    result: state.result
  }), state.step === 5 && /*#__PURE__*/_react.default.createElement(_deploy_step.DeployStep, {
    integrationSettings: state.integrationSettings,
    result: state.result,
    connector: state.connector
  })), /*#__PURE__*/_react.default.createElement(_footer.Footer, {
    currentStep: state.step,
    isGenerating: state.isGenerating,
    isNextStepEnabled: isNextStepEnabled
  })));
});
CreateIntegrationAssistant.displayName = 'CreateIntegrationAssistant';