"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIntegrationNameFromResponse = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This is a hacky way to get the integration name from the response.
 * Since the integration name is not returned in the response we have to parse it from the ingest pipeline name.
 * TODO: Return the package name from the fleet API: https://github.com/elastic/kibana/issues/185932
 */
const getIntegrationNameFromResponse = response => {
  var _response$response, _response$response$;
  const ingestPipelineName = (_response$response = response.response) === null || _response$response === void 0 ? void 0 : (_response$response$ = _response$response[0]) === null || _response$response$ === void 0 ? void 0 : _response$response$.id;
  if (ingestPipelineName) {
    const match = ingestPipelineName.match(/^.*-([a-z\d_]+)\..*-([\d\.]+)$/);
    const integrationName = match === null || match === void 0 ? void 0 : match.at(1);
    const version = match === null || match === void 0 ? void 0 : match.at(2);
    if (integrationName && version) {
      return `${integrationName}-${version}`;
    }
  }
  return '';
};
exports.getIntegrationNameFromResponse = getIntegrationNameFromResponse;