"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsAvailable = exports.useAvailability = void 0;
var _react = require("react");
var _reactUse = require("react-use");
var _constants = require("../../../common/constants");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAvailability = () => {
  const {
    licensing,
    renderUpselling$
  } = (0, _use_kibana.useKibana)().services;
  const licenseService = (0, _reactUse.useObservable)(licensing.license$);
  const renderUpselling = (0, _reactUse.useObservable)(renderUpselling$);
  const hasLicense = (0, _react.useMemo)(() => {
    var _licenseService$hasAt;
    return (_licenseService$hasAt = licenseService === null || licenseService === void 0 ? void 0 : licenseService.hasAtLeast(_constants.MINIMUM_LICENSE_TYPE)) !== null && _licenseService$hasAt !== void 0 ? _licenseService$hasAt : true;
  }, [licenseService]);
  return {
    hasLicense,
    renderUpselling
  };
};
exports.useAvailability = useAvailability;
const useIsAvailable = () => {
  const {
    hasLicense,
    renderUpselling
  } = useAvailability();
  return hasLicense && !renderUpselling;
};
exports.useIsAvailable = useIsAvailable;