"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RELATED_GRAPH_PATH = exports.PLUGIN_ID = exports.MINIMUM_LICENSE_TYPE = exports.INTEGRATION_BUILDER_PATH = exports.INTEGRATION_ASSISTANT_BASE_PATH = exports.INTEGRATION_ASSISTANT_APP_ROUTE = exports.FLEET_PACKAGES_PATH = exports.ECS_GRAPH_PATH = exports.CHECK_PIPELINE_PATH = exports.CATEGORIZATION_GRAPH_PATH = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Plugin information
const PLUGIN_ID = exports.PLUGIN_ID = 'integrationAssistant';

// Public App Routes
const INTEGRATION_ASSISTANT_APP_ROUTE = exports.INTEGRATION_ASSISTANT_APP_ROUTE = '/app/integration_assistant';

// Server API Routes
const INTEGRATION_ASSISTANT_BASE_PATH = exports.INTEGRATION_ASSISTANT_BASE_PATH = '/api/integration_assistant';
const ECS_GRAPH_PATH = exports.ECS_GRAPH_PATH = `${INTEGRATION_ASSISTANT_BASE_PATH}/ecs`;
const CATEGORIZATION_GRAPH_PATH = exports.CATEGORIZATION_GRAPH_PATH = `${INTEGRATION_ASSISTANT_BASE_PATH}/categorization`;
const RELATED_GRAPH_PATH = exports.RELATED_GRAPH_PATH = `${INTEGRATION_ASSISTANT_BASE_PATH}/related`;
const CHECK_PIPELINE_PATH = exports.CHECK_PIPELINE_PATH = `${INTEGRATION_ASSISTANT_BASE_PATH}/pipeline`;
const INTEGRATION_BUILDER_PATH = exports.INTEGRATION_BUILDER_PATH = `${INTEGRATION_ASSISTANT_BASE_PATH}/build`;
const FLEET_PACKAGES_PATH = exports.FLEET_PACKAGES_PATH = `/api/fleet/epm/packages`;

// License
const MINIMUM_LICENSE_TYPE = exports.MINIMUM_LICENSE_TYPE = 'enterprise';