"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESProcessorOptions = exports.ESProcessorItem = void 0;
var _zod = require("zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Processor item for the Elasticsearch processor.
 */

const ESProcessorItem = exports.ESProcessorItem = _zod.z.object({}).catchall(_zod.z.lazy(() => ESProcessorOptions));

/**
 * Processor options for the Elasticsearch processor.
 */

const ESProcessorOptions = exports.ESProcessorOptions = _zod.z.object({
  /**
   * An array of items to execute if the processor fails.
   */
  on_failure: _zod.z.array(ESProcessorItem).optional(),
  /**
   * If true, the processor continues to the next processor if the current processor fails.
   */
  ignore_failure: _zod.z.boolean().optional(),
  /**
   * If true, the processor continues to the next processor if the field is missing.
   */
  ignore_missing: _zod.z.boolean().optional(),
  /**
   * Conditionally execute the processor.
   */
  if: _zod.z.string().optional(),
  /**
   * A tag to assign to the document after processing.
   */
  tag: _zod.z.string().optional()
}).catchall(_zod.z.unknown());