"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EcsMappingResponse = exports.EcsMappingRequestBody = void 0;
var _zod = require("zod");
var _common_attributes = require("../model/common_attributes");
var _response_schemas = require("../model/response_schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EcsMappingRequestBody = exports.EcsMappingRequestBody = _zod.z.object({
  packageName: _common_attributes.PackageName,
  dataStreamName: _common_attributes.DataStreamName,
  rawSamples: _common_attributes.RawSamples,
  mapping: _common_attributes.Mapping.optional(),
  connectorId: _common_attributes.Connector,
  langSmithOptions: _common_attributes.LangSmithOptions.optional()
});
const EcsMappingResponse = exports.EcsMappingResponse = _response_schemas.EcsMappingAPIResponse;