"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.moveRequestParamsToTopLevel = moveRequestParamsToTopLevel;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function moveRequestParamsToTopLevel(response) {
  var _response$json;
  const requestParams = (_response$json = response.json) === null || _response$json === void 0 ? void 0 : _response$json.requestParams;
  if (!requestParams) {
    return response;
  }
  const json = {
    ...response.json
  };
  delete json.requestParams;
  return {
    ...response,
    json,
    requestParams
  };
}