"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineNotFoundFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PipelineNotFoundFlyout = ({
  onClose,
  pipelineName
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    size: "m",
    maxWidth: 550
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, pipelineName && /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    id: "notFoundFlyoutTitle"
  }, /*#__PURE__*/_react.default.createElement("h2", null, pipelineName))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.list.notFoundFlyoutMessage",
      defaultMessage: "Pipeline not found"
    }),
    color: "danger",
    iconType: "warning"
  })));
};
exports.PipelineNotFoundFlyout = PipelineNotFoundFlyout;