"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelinesList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _queryString = require("query-string");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../shared_imports");
var _constants = require("../../constants");
var _navigation = require("../../services/navigation");
var _empty_list = require("./empty_list");
var _table = require("./table");
var _details_flyout = require("./details_flyout");
var _not_found_flyout = require("./not_found_flyout");
var _delete_modal = require("./delete_modal");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPipelineNameFromLocation = location => {
  const {
    pipeline
  } = (0, _queryString.parse)(location.search.substring(1));
  return pipeline;
};
const PipelinesList = ({
  history,
  location
}) => {
  var _services$consolePlug;
  const {
    services
  } = (0, _shared_imports.useKibana)();
  const pipelineNameFromLocation = getPipelineNameFromLocation(location);
  const [selectedPipeline, setSelectedPipeline] = (0, _react.useState)(undefined);
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  const [showPopover, setShowPopover] = (0, _react.useState)(false);
  const [pipelinesToDelete, setPipelinesToDelete] = (0, _react.useState)([]);
  const {
    data,
    isLoading,
    error,
    resendRequest
  } = services.api.useLoadPipelines();

  // Track component loaded
  (0, _react.useEffect)(() => {
    services.metric.trackUiMetric(_constants.UIM_PIPELINES_LIST_LOAD);
    services.breadcrumbs.setBreadcrumbs('home');
  }, [services.metric, services.breadcrumbs]);
  (0, _react.useEffect)(() => {
    if (pipelineNameFromLocation && data !== null && data !== void 0 && data.length) {
      const pipeline = data.find(p => p.name === pipelineNameFromLocation);
      setSelectedPipeline(pipeline);
      setShowFlyout(true);
    }
  }, [pipelineNameFromLocation, data]);
  const goToEditPipeline = pipelineName => {
    const encodedParam = encodeURIComponent(pipelineName);
    history.push((0, _navigation.getEditPath)({
      pipelineName: encodedParam
    }));
  };
  const goToClonePipeline = clonedPipelineName => {
    const encodedParam = encodeURIComponent(clonedPipelineName);
    history.push((0, _navigation.getClonePath)({
      clonedPipelineName: encodedParam
    }));
  };
  const goHome = () => {
    setShowFlyout(false);

    // When redirecting the user to the list of pipelines, we want to only clean
    // up the pipeline query param as there might be other query params (for example:
    // search or filters) that we want to keep.
    const params = new URLSearchParams(history.location.search);
    params.delete('pipeline');
    history.push({
      pathname: '',
      search: params.toString()
    });
  };
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      color: "danger",
      iconType: "warning",
      title: /*#__PURE__*/_react.default.createElement("h2", {
        "data-test-subj": "pipelineLoadError"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.list.loadErrorTitle",
        defaultMessage: "Unable to load pipelines"
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, error.message),
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: resendRequest,
        iconType: "refresh",
        color: "danger"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.list.loadPipelineReloadButton",
        defaultMessage: "Try again"
      }))
    });
  }
  if (isLoading && !data) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, {
      "data-test-subj": "sectionLoading"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.list.loadingMessage",
      defaultMessage: "Loading pipelines..."
    }));
  }
  if (data && data.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_empty_list.EmptyList, null);
  }
  const createMenuItems = [
  /**
   * Create pipeline
   */
  {
    name: _i18n.i18n.translate('xpack.ingestPipelines.list.table.createPipelineButtonLabel', {
      defaultMessage: 'New pipeline'
    }),
    ...(0, _public.reactRouterNavigate)(history, '/create'),
    'data-test-subj': `createNewPipeline`
  },
  /**
   * Create pipeline from CSV
   */
  {
    name: _i18n.i18n.translate('xpack.ingestPipelines.list.table.createPipelineFromCsvButtonLabel', {
      defaultMessage: 'New pipeline from CSV'
    }),
    ...(0, _public.reactRouterNavigate)(history, '/csv_create'),
    'data-test-subj': `createPipelineFromCsv`
  }];
  const renderFlyout = () => {
    if (!showFlyout) {
      return;
    }
    if (selectedPipeline) {
      return /*#__PURE__*/_react.default.createElement(_details_flyout.PipelineDetailsFlyout, {
        pipeline: selectedPipeline,
        onClose: () => {
          setSelectedPipeline(undefined);
          goHome();
        },
        onEditClick: goToEditPipeline,
        onCloneClick: goToClonePipeline,
        onDeleteClick: setPipelinesToDelete
      });
    } else {
      // Somehow we triggered show pipeline details, but do not have a pipeline.
      // We assume not found.
      return /*#__PURE__*/_react.default.createElement(_not_found_flyout.PipelineNotFoundFlyout, {
        onClose: goHome,
        pipelineName: pipelineNameFromLocation
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    bottomBorder: true,
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "appTitle"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.list.listTitle",
      defaultMessage: "Ingest Pipelines"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.list.pipelinesDescription",
      defaultMessage: "Use ingest pipelines to remove or transform fields, extract values from text, and enrich your data before indexing into Elasticsearch."
    }),
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      key: "createPipelinePopover",
      isOpen: showPopover,
      closePopover: () => setShowPopover(false),
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        fill: true,
        iconSide: "right",
        iconType: "arrowDown",
        "data-test-subj": "createPipelineDropdown",
        key: "createPipelineDropdown",
        onClick: () => setShowPopover(previousBool => !previousBool)
      }, _i18n.i18n.translate('xpack.ingestPipelines.list.table.createPipelineDropdownLabel', {
        defaultMessage: 'Create pipeline'
      })),
      panelPaddingSize: "none",
      repositionOnScroll: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
      initialPanelId: 0,
      "data-test-subj": "autoFollowPatternActionContextMenu",
      panels: [{
        id: 0,
        items: createMenuItems
      }]
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      href: services.documentation.getIngestNodeUrl(),
      target: "_blank",
      iconType: "help",
      "data-test-subj": "documentationLink"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.list.pipelinesDocsLinkText",
      defaultMessage: "Documentation"
    }))]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_table.PipelineTable, {
    isLoading: isLoading,
    onReloadClick: resendRequest,
    onEditPipelineClick: goToEditPipeline,
    onDeletePipelineClick: setPipelinesToDelete,
    onClonePipelineClick: goToClonePipeline,
    pipelines: data
  }), renderFlyout(), (pipelinesToDelete === null || pipelinesToDelete === void 0 ? void 0 : pipelinesToDelete.length) > 0 ? /*#__PURE__*/_react.default.createElement(_delete_modal.PipelineDeleteModal, {
    callback: deleteResponse => {
      if (deleteResponse !== null && deleteResponse !== void 0 && deleteResponse.hasDeletedPipelines) {
        // reload pipelines list
        resendRequest();
        setSelectedPipeline(undefined);
        goHome();
      }
      setPipelinesToDelete([]);
    },
    pipelinesToDelete: pipelinesToDelete
  }) : null, (_services$consolePlug = services.consolePlugin) !== null && _services$consolePlug !== void 0 && _services$consolePlug.EmbeddableConsole ? /*#__PURE__*/_react.default.createElement(services.consolePlugin.EmbeddableConsole, null) : null);
};
exports.PipelinesList = PipelinesList;