"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineFormFields = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _bulk_request_panel = require("./bulk_request_panel");
var _collapsible_panel = require("./collapsible_panel");
var _shared_imports = require("../../../shared_imports");
var _pipeline_editor = require("../pipeline_editor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UseField = (0, _shared_imports.getUseField)({
  component: _shared_imports.Field
});
const FormRow = (0, _shared_imports.getFormRow)({
  titleTag: 'h3'
});
const COLUMN_MAX_WIDTH = 420;
const PipelineFormFields = ({
  processors,
  onFailure,
  onLoadJson,
  onProcessorsUpdate,
  hasVersion,
  hasMeta,
  onEditorFlyoutOpen,
  canEditName,
  isEditing
}) => {
  const shouldHaveFixedWidth = (0, _eui.useIsWithinBreakpoints)(['l', 'xl']);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FormRow, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.form.nameTitle",
      defaultMessage: "Name"
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.form.nameDescription",
      defaultMessage: "A unique identifier for this pipeline."
    })
  }, /*#__PURE__*/_react.default.createElement(UseField, {
    path: "name",
    componentProps: {
      ['data-test-subj']: 'nameField',
      euiFieldProps: {
        disabled: canEditName === false || Boolean(isEditing)
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(FormRow, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.form.descriptionFieldTitle",
      defaultMessage: "Description"
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.form.descriptionFieldDescription",
      defaultMessage: "A description of what this pipeline does."
    })
  }, /*#__PURE__*/_react.default.createElement(UseField, {
    path: "description",
    componentProps: {
      ['data-test-subj']: 'descriptionField',
      euiFieldProps: {
        compressed: true
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_pipeline_editor.ProcessorsEditorContextProvider, {
    onFlyoutOpen: onEditorFlyoutOpen,
    onUpdate: onProcessorsUpdate,
    value: {
      processors,
      onFailure
    }
  }, /*#__PURE__*/_react.default.createElement(_pipeline_editor.PipelineEditor, {
    onLoadJson: onLoadJson
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: shouldHaveFixedWidth ? {
      maxWidth: COLUMN_MAX_WIDTH
    } : {}
  }, /*#__PURE__*/_react.default.createElement(_collapsible_panel.CollapsiblePanel, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.form.versionCardTitle",
      defaultMessage: "Add version number"
    }))),
    fieldName: "version",
    toggleProps: {
      'data-test-subj': 'versionToggle'
    },
    accordionProps: {
      'data-test-subj': 'versionAccordion'
    },
    initialToggleState: hasVersion
  }, ({
    isEnabled
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(UseField, {
    path: "version",
    componentProps: {
      ['data-test-subj']: 'versionField',
      euiFieldProps: {
        disabled: !isEnabled
      }
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_collapsible_panel.CollapsiblePanel, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.form.metadataCardTitle",
      defaultMessage: "Add metadata"
    }))),
    fieldName: "_meta",
    toggleProps: {
      'data-test-subj': 'metaToggle'
    },
    accordionProps: {
      'data-test-subj': 'metaAccordion'
    },
    initialToggleState: hasMeta
  }, ({
    isEnabled
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.form.metaDescription",
    defaultMessage: "Any additional information about the ingest pipeline. This information is stored in the cluster state, so best to keep it short."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(UseField, {
    path: "_meta",
    component: _shared_imports.JsonEditorField,
    componentProps: {
      codeEditorProps: {
        readOnly: true,
        'data-test-subj': 'metaEditor',
        height: '200px',
        'aria-label': _i18n.i18n.translate('xpack.ingestPipelines.form.metaAriaLabel', {
          defaultMessage: '_meta field data editor'
        }),
        options: {
          readOnly: !isEnabled,
          lineNumbers: 'off',
          tabSize: 2,
          automaticLayout: true
        }
      }
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_bulk_request_panel.BulkRequestPanel, null))));
};
exports.PipelineFormFields = PipelineFormFields;